/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.TskCoreException;

public class OSInfo {
    private final List<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
    private final Map<Integer, String> attributeMap;
    private final boolean isBackup;
    private final boolean haveFsContent;
    private final long fileSystemId;
    private final boolean haveParentId;
    private final long parentObjId;

    public OSInfo() {
        this.attributeMap = new HashMap<Integer, String>();
        this.isBackup = false;
        this.fileSystemId = 0L;
        this.haveFsContent = false;
        this.parentObjId = 0L;
        this.haveParentId = false;
    }

    public OSInfo(BlackboardArtifact a_art, boolean a_isBackup, long a_fileSystemId, Content a_parent) throws TskCoreException {
        this.artifacts.add(a_art);
        this.isBackup = a_isBackup;
        this.fileSystemId = a_fileSystemId;
        this.haveFsContent = true;
        this.attributeMap = new HashMap<Integer, String>();
        for (BlackboardAttribute attr : a_art.getAttributes()) {
            this.attributeMap.put(attr.getAttributeType().getTypeID(), attr.getValueString());
        }
        if (a_parent != null) {
            this.parentObjId = a_parent.getId();
            this.haveParentId = true;
        } else {
            this.parentObjId = 0L;
            this.haveParentId = false;
        }
    }

    public OSInfo(BlackboardArtifact a_art, boolean a_isBackup, Content a_parent) throws TskCoreException {
        this.artifacts.add(a_art);
        this.isBackup = a_isBackup;
        this.fileSystemId = 0L;
        this.haveFsContent = false;
        if (a_parent != null) {
            this.parentObjId = a_parent.getId();
            this.haveParentId = true;
        } else {
            this.parentObjId = 0L;
            this.haveParentId = false;
        }
        this.attributeMap = new HashMap<Integer, String>();
        for (BlackboardAttribute attr : a_art.getAttributes()) {
            this.attributeMap.put(attr.getAttributeType().getTypeID(), attr.getValueString());
        }
    }

    public boolean matches(OSInfo a_osInfo) {
        if (this.haveParentId && a_osInfo.haveParentId) {
            return this.parentObjId == a_osInfo.parentObjId;
        }
        if (this.haveFsContent && a_osInfo.haveFsContent) {
            return a_osInfo.isBackup == this.isBackup && a_osInfo.fileSystemId == this.fileSystemId;
        }
        return false;
    }

    public void combine(OSInfo a_osInfo) {
        this.artifacts.addAll(a_osInfo.artifacts);
        this.attributeMap.putAll(a_osInfo.attributeMap);
    }

    public List<BlackboardArtifact> getArtifacts() {
        return this.artifacts;
    }

    public boolean haveFileSystem() {
        return this.haveFsContent;
    }

    public long getFileSystemId() {
        return this.fileSystemId;
    }

    public boolean getIsBackup() {
        return this.isBackup;
    }

    public String getAttributeValue(BlackboardAttribute.ATTRIBUTE_TYPE attrType) {
        if (this.attributeMap.containsKey(attrType.getTypeID())) {
            return this.attributeMap.get(attrType.getTypeID());
        }
        return "";
    }

    public String getCompName() {
        return this.getAttributeValue(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME);
    }

    public String getProcessorArchitecture() {
        return this.getAttributeValue(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROCESSOR_ARCHITECTURE);
    }

    public String getDomain() {
        return this.getAttributeValue(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN);
    }

    public String getOSName() {
        return this.getAttributeValue(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME);
    }
}

