/*
 * Decompiled with CFR 0.152.
 */
package ssl;

import armitage.ArmitageMain;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import sleep.bridges.io.IOObject;

public class SecureServerSocket {
    protected ServerSocket server;
    protected String last = "";

    public String last() {
        return this.last;
    }

    public IOObject accept() {
        try {
            Socket client = this.server.accept();
            IOObject temp = new IOObject();
            temp.openRead(client.getInputStream());
            temp.openWrite(new BufferedOutputStream(client.getOutputStream(), 65536));
            this.last = client.getInetAddress().getHostAddress();
            client.setSoTimeout(0);
            return temp;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean authenticate(Socket client, String pass, String host) throws IOException {
        int x;
        DataInputStream authin = new DataInputStream(client.getInputStream());
        DataOutputStream authout = new DataOutputStream(client.getOutputStream());
        int magic = authin.readInt();
        if (magic != 48879) {
            ArmitageMain.print_error("rejected client from " + host + ": invalid auth protocol (old client?)");
            return false;
        }
        int length = authin.readUnsignedByte();
        if (length <= 0) {
            ArmitageMain.print_error("rejected client from " + host + ": bad password length");
            return false;
        }
        StringBuffer mypass = new StringBuffer();
        for (x = 0; x < length; ++x) {
            mypass.append((char)authin.readUnsignedByte());
        }
        for (x = length; x < 256; ++x) {
            authin.readUnsignedByte();
        }
        if (mypass.toString().equals(pass)) {
            authout.writeInt(51966);
            return true;
        }
        authout.writeInt(0);
        ArmitageMain.print_error("rejected client from " + host + ": invalid password");
        return false;
    }

    public IOObject acceptAuthenticated(String pass) {
        try {
            Socket client = this.server.accept();
            if (this.authenticate(client, pass, client.getInetAddress().getHostAddress())) {
                IOObject temp = new IOObject();
                temp.openRead(client.getInputStream());
                temp.openWrite(new BufferedOutputStream(client.getOutputStream(), 65536));
                this.last = client.getInetAddress().getHostAddress();
                client.setSoTimeout(0);
                return temp;
            }
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public SecureServerSocket(int port) throws Exception {
        ServerSocketFactory factory = this.getFactory();
        this.server = factory.createServerSocket(port, 32);
        this.server.setSoTimeout(0);
        this.server.setReuseAddress(true);
    }

    private ServerSocketFactory getFactory() throws Exception {
        return SSLServerSocketFactory.getDefault();
    }

    public ServerSocket getServerSocket() {
        return this.server;
    }

    public String fingerprint() {
        try {
            FileInputStream is = new FileInputStream(System.getProperty("javax.net.ssl.keyStore"));
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, (System.getProperty("javax.net.ssl.keyStorePassword") + "").toCharArray());
            Enumeration<String> en = keystore.aliases();
            if (en.hasMoreElements()) {
                String alias = en.nextElement() + "";
                Certificate cert = keystore.getCertificate(alias);
                byte[] bytesOfMessage = cert.getEncoded();
                MessageDigest md = MessageDigest.getInstance("SHA1");
                byte[] thedigest = md.digest(bytesOfMessage);
                BigInteger bi = new BigInteger(1, thedigest);
                return bi.toString(16);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
        return "unknown";
    }
}

