/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class mxSelectionCellsHandler
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -882368002120921842L;
    public static int DEFAULT_MAX_HANDLERS = 100;
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected Rectangle bounds = null;
    protected int maxHandlers = DEFAULT_MAX_HANDLERS;
    protected transient Map<Object, mxCellHandler> handlers = new LinkedHashMap<Object, mxCellHandler>();
    protected transient mxEventSource.mxIEventListener refreshHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxSelectionCellsHandler.this.refresh();
        }
    };

    public mxSelectionCellsHandler(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        mxGraph mxGraph2 = mxGraphComponent2.getGraph();
        mxGraph2.getSelectionModel().addListener("change", this.refreshHandler);
        mxGraph2.getModel().addListener("change", this.refreshHandler);
        mxGraph2.getView().addListener("scale", this.refreshHandler);
        mxGraph2.getView().addListener("translate", this.refreshHandler);
        mxGraph2.getView().addListener("scaleAndTranslate", this.refreshHandler);
        mxGraph2.getView().addListener("down", this.refreshHandler);
        mxGraph2.getView().addListener("up", this.refreshHandler);
        mxGraph2.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("vertexLabelsMovable") || propertyChangeEvent.getPropertyName().equals("edgeLabelsMovable")) {
                    mxSelectionCellsHandler.this.refresh();
                }
            }
        });
        mxGraphComponent2.addListener("paint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                mxSelectionCellsHandler.this.paintHandles(graphics);
            }
        });
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getMaxHandlers() {
        return this.maxHandlers;
    }

    public void setMaxHandlers(int n) {
        this.maxHandlers = n;
    }

    public mxCellHandler getHandler(Object object) {
        return this.handlers.get(object);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && !this.graphComponent.isForceMarqueeEvent(mouseEvent) && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mousePressed(mouseEvent);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseMoved(mouseEvent);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseDragged(mouseEvent);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseReleased(mouseEvent);
            }
        }
        this.reset();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.graphComponent.getGraphControl());
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        String string = null;
        while (iterator.hasNext() && string == null) {
            string = iterator.next().getToolTipText(mouseEvent2);
        }
        return string;
    }

    public void reset() {
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
    }

    public void refresh() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        Map<Object, mxCellHandler> map2 = this.handlers;
        this.handlers = new LinkedHashMap<Object, mxCellHandler>();
        Object[] objectArray = mxGraph2.getSelectionCells();
        boolean bl = objectArray.length <= this.getMaxHandlers();
        Rectangle rectangle = null;
        for (int i = 0; i < objectArray.length; ++i) {
            mxCellState mxCellState2 = mxGraph2.getView().getState(objectArray[i]);
            if (mxCellState2 == null) continue;
            mxCellHandler mxCellHandler2 = map2.get(objectArray[i]);
            if (mxCellHandler2 != null) {
                mxCellHandler2.refresh(mxCellState2);
            } else {
                mxCellHandler2 = this.graphComponent.createHandler(mxCellState2);
            }
            if (mxCellHandler2 == null) continue;
            mxCellHandler2.setHandlesVisible(bl);
            this.handlers.put(objectArray[i], mxCellHandler2);
            if (rectangle == null) {
                rectangle = mxCellHandler2.getBounds();
                continue;
            }
            rectangle.add(mxCellHandler2.getBounds());
        }
        Rectangle rectangle2 = this.bounds;
        if (rectangle != null) {
            if (rectangle2 != null) {
                rectangle2.add(rectangle);
            } else {
                rectangle2 = rectangle;
            }
        }
        if (rectangle2 != null) {
            this.graphComponent.getGraphControl().repaint(rectangle2);
        }
        this.bounds = rectangle;
    }

    public void paintHandles(Graphics graphics) {
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().paint(graphics);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

