/*
 * Decompiled with CFR 0.152.
 */
package armitage;

import cortana.core.EventManager;
import cortana.core.FilterManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.engine.ObjectUtilities;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.parser.ParserConfig;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;
import ui.MultiFrame;

public class ArmitageMain
implements RuntimeWarningWatcher,
Loadable,
Function {
    protected ScriptVariables variables = new ScriptVariables();

    @Override
    public void processScriptWarning(ScriptWarning warning) {
        ArmitageMain.print_info(warning + "");
    }

    public static final void print_error(String message) {
        System.out.println("\u001b[01;31m[-]\u001b[0m " + message);
    }

    public static final void print_good(String message) {
        System.out.println("\u001b[01;32m[+]\u001b[0m " + message);
    }

    public static final void print_info(String message) {
        System.out.println("\u001b[01;34m[*]\u001b[0m " + message);
    }

    public static final void print_warn(String message) {
        System.out.println("\u001b[01;33m[!]\u001b[0m " + message);
    }

    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        if (name.equals("&_args")) {
            ScalarArray a = BridgeUtilities.getArray(args);
            Stack temp = new Stack();
            Iterator i = a.scalarIterator();
            while (i.hasNext()) {
                temp.add(0, i.next());
            }
            return SleepUtils.getScalar(temp);
        }
        if (name.equals("&print_error")) {
            ArmitageMain.print_error(args.pop() + "");
        } else if (name.equals("&print_good")) {
            ArmitageMain.print_good(args.pop() + "");
        } else if (name.equals("&print_info")) {
            ArmitageMain.print_info(args.pop() + "");
        } else {
            try {
                String file = BridgeUtilities.getString(args, "");
                if (new File(file).exists()) {
                    FileInputStream i = new FileInputStream(file);
                    return SleepUtils.getScalar(i);
                }
                InputStream i = this.getClass().getClassLoader().getResourceAsStream(file);
                return SleepUtils.getScalar(i);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance script) {
        script.addWarningWatcher(this);
        script.setScriptVariables(this.variables);
    }

    @Override
    public void scriptUnloaded(ScriptInstance script) {
    }

    protected String[] getGUIScripts() {
        return new String[]{"scripts/log.sl", "scripts/reporting.sl", "scripts/gui.sl", "scripts/util.sl", "scripts/targets.sl", "scripts/attacks.sl", "scripts/meterpreter.sl", "scripts/process.sl", "scripts/browser.sl", "scripts/pivots.sl", "scripts/services.sl", "scripts/scripts.sl", "scripts/loot.sl", "scripts/tokens.sl", "scripts/downloads.sl", "scripts/shell.sl", "scripts/screenshot.sl", "scripts/hosts.sl", "scripts/passhash.sl", "scripts/jobs.sl", "scripts/preferences.sl", "scripts/modules.sl", "scripts/workspaces.sl", "scripts/menus.sl", "scripts/collaborate.sl", "scripts/armitage.sl"};
    }

    protected String[] getServerScripts() {
        return new String[]{"scripts/util.sl", "scripts/preferences.sl", "scripts/reporting.sl", "scripts/server.sl"};
    }

    public ArmitageMain(String[] args, MultiFrame window, boolean serverMode) {
        ParserConfig.installEscapeConstant('c', "\u0003");
        ParserConfig.installEscapeConstant('U', "\u001f");
        ParserConfig.installEscapeConstant('o', "\u000f");
        Hashtable<String, ArmitageMain> environment = new Hashtable<String, ArmitageMain>();
        environment.put("&resource", this);
        environment.put("&_args", this);
        environment.put("&print_error", this);
        environment.put("&print_good", this);
        environment.put("&print_info", this);
        this.variables.putScalar("@ARGV", ObjectUtilities.BuildScalar(false, args));
        ScriptLoader loader = new ScriptLoader();
        loader.addSpecificBridge(this);
        if (!serverMode) {
            EventManager events = new EventManager();
            FilterManager filters = new FilterManager();
            this.variables.putScalar("$__events__", SleepUtils.getScalar(events));
            this.variables.putScalar("$__filters__", SleepUtils.getScalar(filters));
            this.variables.putScalar("$__frame__", SleepUtils.getScalar(window));
            loader.addGlobalBridge(events.getBridge());
            loader.addGlobalBridge(filters.getBridge());
        }
        String[] scripts = serverMode ? this.getServerScripts() : this.getGUIScripts();
        int x = -1;
        try {
            for (x = 0; x < scripts.length; ++x) {
                InputStream i = this.getClass().getClassLoader().getResourceAsStream(scripts[x]);
                ScriptInstance si = loader.loadScript(scripts[x], i, environment);
                si.runScript();
            }
        }
        catch (YourCodeSucksException yex) {
            System.out.println("*** File: " + scripts[x]);
            yex.printErrors(System.out);
        }
        catch (IOException ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        boolean serverMode = false;
        int x = 0;
        for (x = 0; x < args.length; ++x) {
            if (!args[x].equals("--server")) continue;
            serverMode = true;
        }
        if (serverMode) {
            new ArmitageMain(args, null, serverMode);
        } else {
            MultiFrame.setupLookAndFeel();
            MultiFrame frame = new MultiFrame();
            new ArmitageMain(args, frame, serverMode);
        }
    }
}

