/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import cortana.data.Service;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Host {
    protected Map sessions;
    protected Map services;
    protected String address;
    protected Map data;

    public Host(String address, Map data) {
        this.address = address;
        this.data = data;
        this.sessions = new HashMap();
        this.services = new HashMap();
        this.fixOSValues();
        data.put("sessions", this.sessions);
        data.put("services", this.services);
    }

    public Map getData() {
        return this.data;
    }

    public Map getSessions() {
        return this.sessions;
    }

    public Map getServices() {
        return this.services;
    }

    public boolean hasService(String port) {
        return this.services.containsKey(port);
    }

    public Set serviceSet() {
        HashSet<Service> rv = new HashSet<Service>();
        Iterator i = this.services.keySet().iterator();
        while (i.hasNext()) {
            rv.add(new Service(this.address, i.next() + ""));
        }
        return rv;
    }

    protected void fixOSValues() {
        if ("".equals(this.data.get("os_name"))) {
            this.data.put("os_name", "Unknown");
        } else {
            this.data.put("os_match", this.data.get("os_name") + " " + this.data.get("os_flavor") + " " + this.data.get("os_sp"));
        }
        this.data.put("show", Boolean.TRUE);
    }

    public void update(Map data) {
        this.data.putAll(data);
        this.fixOSValues();
    }
}

