/*
 * Decompiled with CFR 0.152.
 */
package cortana.core;

import cortana.core.FilterManager;
import java.util.Hashtable;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.interfaces.Environment;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class Filters
implements Function,
Environment,
Loadable {
    protected FilterManager manager;

    @Override
    public void scriptLoaded(ScriptInstance si) {
        Hashtable environment = si.getScriptEnvironment().getEnvironment();
        environment.put("filter", this);
        environment.put("&filter_data", this);
        environment.put("&filter_data_array", this);
        environment.put("&filterd", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance si) {
    }

    protected void addFilter(String name, SleepClosure c) {
        this.manager.addFilter(name, c);
    }

    @Override
    public void bindFunction(ScriptInstance si, String type, String event, Block body) {
        SleepClosure f = new SleepClosure(si, body);
        this.addFilter(event, f);
    }

    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        args = (Stack)args.clone();
        if (name.equals("&filter_data")) {
            String event = BridgeUtilities.getString(args, "");
            Stack results = this.manager.filterScalarData(event, args);
            Scalar r = SleepUtils.getArrayScalar();
            while (!results.isEmpty()) {
                r.getArray().push((Scalar)results.pop());
            }
            return r;
        }
        if (name.equals("&filter_data_array")) {
            Stack<Scalar> argz = new Stack<Scalar>();
            Scalar event = BridgeUtilities.getScalar(args);
            ScalarArray temp = BridgeUtilities.getArray(args);
            while (temp.size() > 0) {
                argz.push(temp.pop());
            }
            argz.push(event);
            return this.evaluate("&filter_data", script, argz);
        }
        String event = BridgeUtilities.getString(args, "");
        SleepClosure f = BridgeUtilities.getFunction(args, script);
        this.addFilter(event, f);
        return SleepUtils.getEmptyScalar();
    }

    public Filters(FilterManager m) {
        this.manager = m;
    }
}

