/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxHtmlCanvas
extends mxBasicCanvas {
    protected Document document;

    public mxHtmlCanvas() {
        this(null);
    }

    public mxHtmlCanvas(Document document) {
        this.setDocument(document);
    }

    public void appendHtmlElement(Element element) {
        Node node;
        if (this.document != null && (node = this.document.getDocumentElement().getFirstChild().getNextSibling()) != null) {
            node.appendChild(element);
        }
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public Object drawCell(mxCellState mxCellState2) {
        Map<String, Object> map2 = mxCellState2.getStyle();
        if (mxCellState2.getAbsolutePointCount() > 1) {
            List<mxPoint> list = mxCellState2.getAbsolutePoints();
            list = mxUtils.translatePoints(list, this.translate.x, this.translate.y);
            this.drawLine(list, map2);
        } else {
            int n = (int)mxCellState2.getX() + this.translate.x;
            int n2 = (int)mxCellState2.getY() + this.translate.y;
            int n3 = (int)mxCellState2.getWidth();
            int n4 = (int)mxCellState2.getHeight();
            if (!mxUtils.getString(map2, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                this.drawShape(n, n2, n3, n4, map2);
            } else {
                int n5 = (int)Math.round((double)mxUtils.getInt(map2, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>(map2);
                hashtable.remove(mxConstants.STYLE_FILLCOLOR);
                hashtable.remove(mxConstants.STYLE_ROUNDED);
                if (mxUtils.isTrue(map2, mxConstants.STYLE_HORIZONTAL, true)) {
                    this.drawShape(n, n2, n3, n5, map2);
                    this.drawShape(n, n2 + n5, n3, n4 - n5, hashtable);
                } else {
                    this.drawShape(n, n2, n5, n4, map2);
                    this.drawShape(n + n5, n2, n3 - n5, n4, hashtable);
                }
            }
        }
        return null;
    }

    @Override
    public Object drawLabel(String string, mxCellState mxCellState2, boolean bl) {
        mxRectangle mxRectangle2 = mxCellState2.getLabelBounds();
        if (this.drawLabels && mxRectangle2 != null) {
            int n = (int)mxRectangle2.getX() + this.translate.x;
            int n2 = (int)mxRectangle2.getY() + this.translate.y;
            int n3 = (int)mxRectangle2.getWidth();
            int n4 = (int)mxRectangle2.getHeight();
            Map<String, Object> map2 = mxCellState2.getStyle();
            return this.drawText(string, n, n2, n3, n4, map2);
        }
        return null;
    }

    public Element drawShape(int n, int n2, int n3, int n4, Map<String, Object> map2) {
        Object object;
        String string = mxUtils.getString(map2, mxConstants.STYLE_FILLCOLOR);
        String string2 = mxUtils.getString(map2, mxConstants.STYLE_STROKECOLOR);
        float f = (float)((double)mxUtils.getFloat(map2, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        String string3 = mxUtils.getString(map2, mxConstants.STYLE_SHAPE);
        Element element = this.document.createElement("div");
        if (string3.equals("line")) {
            object = mxUtils.getString(map2, mxConstants.STYLE_DIRECTION, "east");
            if (((String)object).equals("east") || ((String)object).equals("west")) {
                n2 = Math.round(n2 + n4 / 2);
                n4 = 1;
            } else {
                n = Math.round(n2 + n3 / 2);
                n3 = 1;
            }
        }
        if (mxUtils.isTrue(map2, mxConstants.STYLE_SHADOW, false) && string != null) {
            object = (Element)element.cloneNode(true);
            String string4 = "overflow:hidden;position:absolute;left:" + String.valueOf(n + mxConstants.SHADOW_OFFSETX) + "px;" + "top:" + String.valueOf(n2 + mxConstants.SHADOW_OFFSETY) + "px;" + "width:" + String.valueOf(n3) + "px;" + "height:" + String.valueOf(n4) + "px;background:" + mxConstants.W3C_SHADOWCOLOR + ";border-style:solid;border-color:" + mxConstants.W3C_SHADOWCOLOR + ";border-width:" + String.valueOf(Math.round(f)) + ";";
            object.setAttribute("style", string4);
            this.appendHtmlElement((Element)object);
        }
        if (string3.equals("image") && (object = this.getImageForStyle(map2)) != null) {
            element = this.document.createElement("img");
            element.setAttribute("border", "0");
            element.setAttribute("src", (String)object);
        }
        object = "overflow:hidden;position:absolute;left:" + String.valueOf(n) + "px;" + "top:" + String.valueOf(n2) + "px;" + "width:" + String.valueOf(n3) + "px;" + "height:" + String.valueOf(n4) + "px;background:" + string + ";" + ";border-style:solid;border-color:" + string2 + ";border-width:" + String.valueOf(Math.round(f)) + ";";
        element.setAttribute("style", (String)object);
        this.appendHtmlElement(element);
        return element;
    }

    public void drawLine(List<mxPoint> list, Map<String, Object> map2) {
        String string = mxUtils.getString(map2, mxConstants.STYLE_STROKECOLOR);
        int n = (int)((double)mxUtils.getInt(map2, mxConstants.STYLE_STROKEWIDTH, 1) * this.scale);
        if (string != null && n > 0) {
            mxPoint mxPoint2 = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                mxPoint mxPoint3 = list.get(i);
                this.drawSegment((int)mxPoint2.getX(), (int)mxPoint2.getY(), (int)mxPoint3.getX(), (int)mxPoint3.getY(), string, n);
                mxPoint2 = mxPoint3;
            }
        }
    }

    protected void drawSegment(int n, int n2, int n3, int n4, String string, int n5) {
        int n6 = Math.min(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n, n3) - n6;
        int n9 = Math.max(n2, n4) - n7;
        n = n6;
        n2 = n7;
        if (n8 == 0 || n9 == 0) {
            String string2 = "overflow:hidden;position:absolute;left:" + String.valueOf(n) + "px;" + "top:" + String.valueOf(n2) + "px;" + "width:" + String.valueOf(n8) + "px;" + "height:" + String.valueOf(n9) + "px;" + "border-color:" + string + ";" + "border-style:solid;" + "border-width:1 1 0 0px;";
            Element element = this.document.createElement("div");
            element.setAttribute("style", string2);
            this.appendHtmlElement(element);
        } else {
            int n10 = n + (n3 - n) / 2;
            this.drawSegment(n, n2, n10, n2, string, n5);
            this.drawSegment(n10, n2, n10, n4, string, n5);
            this.drawSegment(n10, n4, n3, n4, string, n5);
        }
    }

    public Element drawText(String string, int n, int n2, int n3, int n4, Map<String, Object> map2) {
        Element element = mxUtils.createTable(this.document, string, n, n2, n3, n4, this.scale, map2);
        this.appendHtmlElement(element);
        return element;
    }
}

