/*
 * Decompiled with CFR 0.152.
 */
package sleep.parser;

import sleep.parser.Checkers;
import sleep.parser.CommentRule;
import sleep.parser.Parser;
import sleep.parser.ParserUtilities;
import sleep.parser.Rule;
import sleep.parser.StringIterator;
import sleep.parser.Token;
import sleep.parser.TokenList;

public class LexicalAnalyzer {
    protected static Rule PAREN_RULE;
    protected static Rule BLOCK_RULE;
    protected static Rule INDEX_RULE;
    protected static Rule DQUOTE_RULE;
    protected static Rule SQUOTE_RULE;
    protected static Rule BACKTICK_RULE;
    protected static Rule COMMENT_RULE;
    protected static char EndOfTerm;

    private static boolean isSkippable(Parser parser, char c) {
        return LexicalAnalyzer.isWhite(c) || LexicalAnalyzer.isEndOfTerm(parser, c) || LexicalAnalyzer.isEndOfLine(c);
    }

    private static boolean isWhite(char c) {
        return c == ' ' || c == '\t';
    }

    private static boolean isBuiltInOperator(char c, StringBuffer stringBuffer, StringIterator stringIterator) {
        return c == '.' && (stringBuffer.length() <= 0 || !Character.isDigit(stringBuffer.charAt(stringBuffer.length() - 1)) || stringBuffer.charAt(0) == '$') && !stringIterator.isNextChar('=');
    }

    private static boolean isEndOfTerm(Parser parser, char c) {
        return c == parser.EndOfTerm;
    }

    private static boolean isEndOfLine(char c) {
        return c == '\n' || c == '\r';
    }

    public static TokenList GroupBlockTokens(Parser parser, StringIterator stringIterator) {
        return LexicalAnalyzer.GroupTokens(parser, stringIterator, ';');
    }

    public static TokenList GroupExpressionIndexTokens(Parser parser, StringIterator stringIterator) {
        return LexicalAnalyzer.GroupTokens(parser, stringIterator, ':');
    }

    private static TokenList GroupTokens(Parser parser, StringIterator stringIterator, char c) {
        parser.setEndOfTerm(c);
        Token[] tokenArray = LexicalAnalyzer.CreateTerms(parser, stringIterator).getTokens();
        TokenList tokenList = new TokenList();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < tokenArray.length; ++i) {
            if (i + 1 < tokenArray.length) {
                String string = tokenArray[i].toString();
                String string2 = tokenArray[i + 1].toString();
                n = i;
                if (i + 2 < tokenArray.length && Checkers.isClassLiteral(string) && string2.equals(".")) {
                    stringBuffer.append(tokenArray[i]);
                    while (i + 2 < tokenArray.length && tokenArray[i + 1].toString().equals(".") && Checkers.isClassPiece(tokenArray[i + 2].toString())) {
                        stringBuffer.append(".");
                        stringBuffer.append(tokenArray[i + 2]);
                        i += 2;
                    }
                } else if (Checkers.isFunctionCall(string, string2) || Checkers.isIndexableItem(string, string2)) {
                    stringBuffer.append(string.toString());
                    stringBuffer.append(string2.toString());
                    ++i;
                    while (i + 1 < tokenArray.length && Checkers.isIndex(tokenArray[i + 1].toString())) {
                        stringBuffer.append(tokenArray[i + 1].toString());
                        ++i;
                    }
                }
            }
            if (stringBuffer.length() > 0) {
                tokenList.add(ParserUtilities.makeToken(stringBuffer.toString(), tokenArray[n]));
                stringBuffer = new StringBuffer();
                continue;
            }
            if (!Checkers.isComment(tokenArray[i].toString())) {
                tokenList.add(tokenArray[i]);
                continue;
            }
            parser.addComment(tokenArray[i].toString());
        }
        return tokenList;
    }

    public static TokenList GroupParameterTokens(Parser parser, StringIterator stringIterator) {
        return LexicalAnalyzer.GroupTokens(parser, stringIterator, ',');
    }

    public static TokenList CreateTerms(Parser parser, StringIterator stringIterator) {
        return LexicalAnalyzer.CreateTerms(parser, stringIterator, true, true);
    }

    public static TokenList CreateTerms(Parser parser, StringIterator stringIterator, boolean bl, boolean bl2) {
        Rule[] ruleArray = new Rule[]{PAREN_RULE.copyRule(), BLOCK_RULE.copyRule(), DQUOTE_RULE.copyRule(), SQUOTE_RULE.copyRule(), INDEX_RULE.copyRule(), BACKTICK_RULE.copyRule(), COMMENT_RULE};
        return LexicalAnalyzer.CreateTerms(parser, stringIterator, ruleArray, bl, bl2);
    }

    private static String AdvanceTerms(Parser parser, StringIterator stringIterator, Rule rule, Rule[] ruleArray) {
        rule.witnessOpen(new Token(stringIterator.getEntireLine(), stringIterator.getLineNumber(), stringIterator.getLineMarker()));
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringIterator.getLineNumber();
        while (stringIterator.hasNext()) {
            char c = stringIterator.next();
            if (c == '\\' && rule.getType() == Rule.PRESERVE_SINGLE && rule != COMMENT_RULE) {
                if (!stringIterator.hasNext() && parser != null) {
                    parser.reportError("Escape is end of string", new Token(stringBuffer.toString(), stringIterator.getLineNumber(), stringIterator.getLineMarker()));
                    continue;
                }
                stringBuffer.append(c);
                stringBuffer.append(stringIterator.next());
                continue;
            }
            if (rule.isRight(c) || rule.isMatch(c)) {
                rule.witnessClose(new Token(stringIterator.getEntireLine(), stringIterator.getLineNumber(), stringIterator.getLineMarker()));
                return stringBuffer.toString();
            }
            if (rule.getType() != Rule.PRESERVE_SINGLE && rule != COMMENT_RULE) {
                boolean bl = false;
                for (int i = 0; i < ruleArray.length; ++i) {
                    if (ruleArray[i].isLeft(c) || ruleArray[i].isMatch(c)) {
                        String string = LexicalAnalyzer.AdvanceTerms(parser, stringIterator, ruleArray[i], ruleArray);
                        if (string == null) {
                            return null;
                        }
                        stringBuffer.append(ruleArray[i].wrap(string));
                        bl = true;
                        break;
                    }
                    if (!ruleArray[i].isRight(c) || ruleArray[i] == rule) continue;
                    ruleArray[i].witnessClose(new Token(stringIterator.getEntireLine(), stringIterator.getLineNumber(), stringIterator.getLineMarker()));
                }
                if (bl) continue;
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return null;
    }

    public static TokenList CreateTerms(Parser parser, StringIterator stringIterator, Rule[] ruleArray, boolean bl, boolean bl2) {
        Token token;
        char c;
        TokenList tokenList = new TokenList();
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringIterator.hasNext()) {
            bl3 = false;
            c = stringIterator.next();
            for (int i = 0; i < ruleArray.length; ++i) {
                if (ruleArray[i].isLeft(c) || ruleArray[i].isMatch(c)) {
                    if (stringBuffer.length() > 0) {
                        token = new Token(LexicalAnalyzer.trim(parser, stringBuffer.toString()), stringIterator.getLineNumber());
                        tokenList.add(token);
                        stringBuffer = new StringBuffer();
                    }
                    int n = stringIterator.getLineNumber();
                    String string = LexicalAnalyzer.AdvanceTerms(parser, stringIterator, ruleArray[i], ruleArray);
                    if (string == null) {
                        string = "";
                    }
                    token = new Token(ruleArray[i].wrap(string), n);
                    tokenList.add(token);
                    bl3 = true;
                    break;
                }
                if (!ruleArray[i].isRight(c)) continue;
                ruleArray[i].witnessClose(new Token(stringIterator.getEntireLine(), stringIterator.getLineNumber()));
            }
            if (bl3) continue;
            if (LexicalAnalyzer.isEndOfTerm(parser, c)) {
                if (stringBuffer.length() > 0) {
                    token = new Token(LexicalAnalyzer.trim(parser, stringBuffer.toString()), stringIterator.getLineNumber());
                    tokenList.add(token);
                    stringBuffer = new StringBuffer();
                }
                token = new Token("EOT", stringIterator.getLineNumber());
                tokenList.add(token);
                continue;
            }
            if (LexicalAnalyzer.isBuiltInOperator(c, stringBuffer, stringIterator)) {
                if (stringBuffer.length() > 0) {
                    token = new Token(LexicalAnalyzer.trim(parser, stringBuffer.toString()), stringIterator.getLineNumber());
                    tokenList.add(token);
                    stringBuffer = new StringBuffer();
                }
                tokenList.add(new Token(c + "", stringIterator.getLineNumber()));
                continue;
            }
            if (LexicalAnalyzer.isSkippable(parser, c)) {
                if (stringBuffer.length() <= 0) continue;
                token = stringBuffer.length() == 1 && stringBuffer.charAt(0) == '%' ? new Token("% ", stringIterator.getLineNumber()) : new Token(LexicalAnalyzer.trim(parser, stringBuffer.toString()), stringIterator.getLineNumber());
                tokenList.add(token);
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            token = new Token(LexicalAnalyzer.trim(parser, stringBuffer.toString()), stringIterator.getLineNumber());
            tokenList.add(token);
        }
        for (c = '\u0000'; c < ruleArray.length; ++c) {
            if (ruleArray[c].isBalanced()) continue;
            parser.reportError(ruleArray[c].getSyntaxError());
        }
        return tokenList;
    }

    public static String trim(Parser parser, String string) {
        int n;
        int n2;
        if (string.length() == 0 || string.equals(" ")) {
            return "";
        }
        for (n2 = 0; n2 < string.length() && LexicalAnalyzer.isSkippable(parser, string.charAt(n2)); ++n2) {
        }
        for (n = string.length() - 1; n > 0 && LexicalAnalyzer.isSkippable(parser, string.charAt(n)); --n) {
        }
        if (n2 > n) {
            return "";
        }
        return string.substring(n2, n + 1);
    }

    static {
        BLOCK_RULE = new Rule("Mismatched Braces - missing open brace", "Mismatched Braces - missing close brace", '{', '}');
        INDEX_RULE = new Rule("Mismatched Indices - missing open index", "Mismatched Indices - missing close index", '[', ']');
        DQUOTE_RULE = new Rule("Runaway string", '\"');
        SQUOTE_RULE = new Rule("Runaway string", '\'');
        BACKTICK_RULE = new Rule("Runaway string", '`');
        PAREN_RULE = new Rule("Mismatched Parentheses - missing open paren", "Mismatched Parentheses - missing close paren", '(', ')');
        COMMENT_RULE = new CommentRule();
        EndOfTerm = (char)59;
    }
}

