/*
 * Decompiled with CFR 0.152.
 */
package msf;

import armitage.ArmitageMain;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import msf.RpcConnection;

public class RpcCacheImpl
implements Runnable {
    protected RpcConnection connection = null;
    protected Map cache = new HashMap();
    protected Map filters = new HashMap();
    private static final Object[] emptyFilter = new Object[]{new HashMap()};
    protected Object sessions = null;

    public RpcCacheImpl(RpcConnection connection) {
        this.connection = connection;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String user, Object[] filter) {
        RpcCacheImpl rpcCacheImpl = this;
        synchronized (rpcCacheImpl) {
            if (filter == null || filter.length == 0) {
                this.filters.remove(user);
                return;
            }
            Map temp = (Map)filter[0];
            if (temp.size() == 0) {
                this.filters.remove(user);
            } else {
                this.filters.put(user, filter);
            }
        }
    }

    public Object execute(String user, String methodName) throws IOException {
        return this.execute(methodName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute_cache(String cacheKey, String methodName, Object[] params) throws IOException {
        RpcCacheImpl rpcCacheImpl = this;
        synchronized (rpcCacheImpl) {
            CacheEntry entry = null;
            if (this.cache.containsKey(cacheKey)) {
                entry = (CacheEntry)this.cache.get(cacheKey);
                if (!entry.isExpired()) {
                    return entry.response;
                }
            } else {
                entry = new CacheEntry();
                this.cache.put(cacheKey, entry);
            }
            long time = System.currentTimeMillis();
            entry.response = params == null ? this.connection.execute(methodName) : this.connection.execute(methodName, params);
            time = System.currentTimeMillis() - time;
            entry.touch(methodName, time);
            return entry.response;
        }
    }

    private static String cacheKey(String method, Object[] args) {
        Map temp = (Map)args[0];
        StringBuffer key = new StringBuffer();
        key.append(method + ":");
        key.append(temp.get("hosts"));
        key.append(";");
        key.append(temp.get("os"));
        key.append(";");
        key.append(temp.get("ports"));
        key.append(";");
        key.append(temp.get("session"));
        key.append(";");
        key.append(temp.get("labels"));
        return key.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(String user, String methodName, Object[] params) throws IOException {
        RpcCacheImpl rpcCacheImpl = this;
        synchronized (rpcCacheImpl) {
            if (!methodName.equals("session.list") && this.filters.containsKey(user)) {
                Object[] filter = (Object[])this.filters.get(user);
                this.connection.execute("db.filter", filter);
                String key = RpcCacheImpl.cacheKey(methodName, filter);
                Object response = this.execute_cache(key, methodName, params);
                this.connection.execute("db.filter", emptyFilter);
                return response;
            }
            if (!methodName.equals("session.list")) return this.execute_cache(methodName, methodName, params);
            RpcCacheImpl rpcCacheImpl2 = this;
            synchronized (rpcCacheImpl2) {
                if (this.sessions != null) {
                    return this.sessions;
                }
                return this.execute_cache(methodName, methodName, params);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Object temp = this.connection.execute("session.list");
                RpcCacheImpl rpcCacheImpl = this;
                synchronized (rpcCacheImpl) {
                    this.sessions = temp;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static class CacheEntry {
        public long last = 0L;
        public long wait = 2000L;
        public Object response = null;

        private CacheEntry() {
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.last > this.wait;
        }

        public void touch(String method, long executeTime) {
            if (executeTime > 500L) {
                this.wait = 5000L;
                ArmitageMain.print_info(method + " took " + executeTime + "ms - throttling next call");
            } else {
                this.wait = 2000L;
            }
            this.last = System.currentTimeMillis();
        }
    }
}

