/*
 * Decompiled with CFR 0.152.
 */
package cortana.metasploit;

import cortana.Safety;
import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.metasploit.ShellSession;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import msf.RpcConnection;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class ShellBridge
implements Loadable,
Function,
ShellSession.ShellCallback {
    protected EventManager events;
    protected FilterManager filters;
    protected RpcConnection client;
    protected RpcConnection dserver;
    protected Map sessions;

    @Override
    public void commandUpdate(String session, Object token, String output) {
        if (!(token instanceof ShellToken)) {
            return;
        }
        ScriptInstance script = ((ShellToken)token).script;
        String command = ((ShellToken)token).command;
        SleepClosure function2 = ((ShellToken)token).function;
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(FilterManager.convertAll(output));
        args.push(SleepUtils.getScalar(command));
        args.push(SleepUtils.getScalar(session));
        if (function2 == null) {
            this.events.fireEvent("shell_read", args, script);
        } else {
            SleepUtils.runCode(function2, "read", script, args);
        }
    }

    @Override
    public void commandComplete(String session, Object token, String output) {
        if (!(token instanceof ShellToken)) {
            return;
        }
        ScriptInstance script = ((ShellToken)token).script;
        String command = ((ShellToken)token).command;
        SleepClosure function2 = ((ShellToken)token).function;
        String[] first = command.split("\\s+");
        if (first.length == 0) {
            return;
        }
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(FilterManager.convertAll(output));
        args.push(SleepUtils.getScalar(command));
        args.push(SleepUtils.getScalar(session));
        if (function2 == null) {
            this.events.fireEvent("shell_" + first[0].toLowerCase(), args, script);
            this.events.fireEvent("shell", args, script);
        } else {
            SleepUtils.runCode(function2, "complete", script, args);
        }
    }

    public ShellSession getSession(String sid) {
        if (this.sessions.containsKey(sid)) {
            return (ShellSession)this.sessions.get(sid);
        }
        ShellSession m = new ShellSession(this.client, this.dserver, sid);
        m.addListener(this);
        this.sessions.put(sid, m);
        return m;
    }

    public ShellBridge(RpcConnection client, RpcConnection dserver, EventManager events, FilterManager filters) {
        this.client = client;
        this.dserver = dserver;
        this.events = events;
        this.filters = filters;
        this.sessions = new HashMap();
    }

    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        SleepClosure f;
        String sid = BridgeUtilities.getString(args, "");
        String command = BridgeUtilities.getString(args, "");
        ShellSession session = this.getSession(sid);
        ShellToken token = new ShellToken();
        token.script = script;
        token.command = command;
        token.function = args.isEmpty() ? null : (f = BridgeUtilities.getFunction(args, script));
        if (Safety.shouldAsk(script)) {
            StringBuffer description = new StringBuffer();
            description.append("<html><body><b>");
            description.append(new File(script.getName()).getName());
            description.append("</b> wants to write to shell session <b>");
            description.append(sid);
            description.append("</b>:</html></body>\n\n<html><body><b>");
            description.append(command);
            description.append("</b></body></html>\n\nWould you like to allow this?");
            if (!Safety.ask(script, description.toString(), "shell " + sid + ": '" + command + "'")) {
                return SleepUtils.getEmptyScalar();
            }
        }
        if (Safety.shouldLog(script)) {
            Safety.log(script, "shell " + sid + " - '" + command + "'");
        }
        session.addCommand(token, command);
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance si) {
        si.getScriptEnvironment().getEnvironment().put("&s_cmd", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance si) {
    }

    private static class ShellToken {
        public ScriptInstance script;
        public String command;
        public SleepClosure function;

        private ShellToken() {
        }
    }
}

