/*
 * Decompiled with CFR 0.152.
 */
package cortana.core;

import cortana.core.EventQueue;
import cortana.core.Events;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.interfaces.Loadable;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class EventManager {
    protected Map listeners = new HashMap();
    protected EventQueue queue = new EventQueue(this);

    protected List getListener(String name) {
        if (this.listeners.containsKey(name)) {
            return (List)this.listeners.get(name);
        }
        this.listeners.put(name, new LinkedList());
        return (List)this.listeners.get(name);
    }

    public Loadable getBridge() {
        return new Events(this);
    }

    public void addListener(String listener, SleepClosure c, boolean temporary) {
        this.getListener(listener).add(new Listener(c, temporary));
    }

    public static Stack shallowCopy(Stack args) {
        Stack copy2 = new Stack();
        Iterator i = args.iterator();
        while (i.hasNext()) {
            copy2.push(i.next());
        }
        return copy2;
    }

    public void fireEvent(String eventName, Stack args) {
        this.fireEvent(eventName, args, null);
    }

    public void fireEventAsync(String eventName, Stack args) {
        this.queue.add(eventName, args);
    }

    public void fireEvent(String eventName, Stack args, ScriptInstance local) {
        List listeners = this.getListener(eventName);
        if (listeners.size() == 0) {
            return;
        }
        Iterator i = listeners.iterator();
        LinkedList<SleepClosure> callme = new LinkedList<SleepClosure>();
        Object lid = null;
        if (local != null) {
            lid = local.getMetadata().get("%scriptid%");
        }
        while (i.hasNext()) {
            Listener l = (Listener)i.next();
            if (!l.getClosure().getOwner().isLoaded()) {
                i.remove();
                continue;
            }
            if (lid != null && !lid.equals(l.getClosure().getOwner().getMetadata().get("%scriptid%"))) continue;
            callme.add(l.getClosure());
            if (!l.isTemporary()) continue;
            i.remove();
        }
        for (SleepClosure c : callme) {
            SleepUtils.runCode(c, eventName, null, EventManager.shallowCopy(args));
        }
    }

    private static class Listener {
        protected SleepClosure listener;
        protected boolean temporary;

        public Listener(SleepClosure listener, boolean temporary) {
            this.listener = listener;
            this.temporary = temporary;
        }

        public SleepClosure getClosure() {
            return this.listener;
        }

        public boolean isTemporary() {
            return this.temporary;
        }
    }
}

