/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sleuthkit.datamodel.CaseDbConnectionInfo;
import org.sleuthkit.datamodel.HashEntry;
import org.sleuthkit.datamodel.HashHitInfo;
import org.sleuthkit.datamodel.LibraryUtils;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskDataException;

public class SleuthkitJNI {
    private static final ReadWriteLock tskLock = new ReentrantReadWriteLock();

    private SleuthkitJNI() {
    }

    static CaseDbHandle newCaseDb(String path) throws TskCoreException {
        return new CaseDbHandle(SleuthkitJNI.newCaseDbNat(path));
    }

    static CaseDbHandle newCaseDb(String databaseName, CaseDbConnectionInfo info) throws TskCoreException {
        return new CaseDbHandle(SleuthkitJNI.newCaseDbMultiNat(info.getHost(), info.getPort(), info.getUserName(), info.getPassword(), info.getDbType().ordinal(), databaseName));
    }

    static CaseDbHandle openCaseDb(String path) throws TskCoreException {
        return new CaseDbHandle(SleuthkitJNI.openCaseDbNat(path));
    }

    static CaseDbHandle openCaseDb(String databaseName, CaseDbConnectionInfo info) throws TskCoreException {
        return new CaseDbHandle(SleuthkitJNI.openCaseDbMultiNat(info.getHost(), info.getPort(), info.getUserName(), info.getPassword(), info.getDbType().ordinal(), databaseName));
    }

    public static String getVersion() {
        return SleuthkitJNI.getVersionNat();
    }

    public static void startVerboseLogging(String logPath) {
        SleuthkitJNI.startVerboseLoggingNat(logPath);
    }

    public static long openImage(String[] imageFiles, SleuthkitCase skCase) throws TskCoreException {
        if (skCase == null) {
            throw new TskCoreException("SleuthkitCase can not be null");
        }
        return SleuthkitJNI.openImage(imageFiles, 0, true, skCase.getCaseHandle().caseDbPointer);
    }

    public static long openImage(String[] imageFiles, int sSize, SleuthkitCase skCase) throws TskCoreException {
        if (skCase == null) {
            throw new TskCoreException("SleuthkitCase can not be null");
        }
        return SleuthkitJNI.openImage(imageFiles, sSize, true, skCase.getCaseHandle().caseDbPointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long openImage(String[] imageFiles, int sSize, boolean useCache, Long caseDbPointer) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            long imageHandle;
            StringBuilder keyBuilder = new StringBuilder();
            for (int i = 0; i < imageFiles.length; ++i) {
                keyBuilder.append(imageFiles[i]);
            }
            String imageKey = keyBuilder.toString();
            Object object = HandleCache.cacheLock;
            synchronized (object) {
                Long nonNullCaseDbPointer = caseDbPointer;
                if (nonNullCaseDbPointer == null) {
                    nonNullCaseDbPointer = HandleCache.getDefaultCaseDbPointer();
                }
                if (!useCache && HandleCache.getCaseHandles(nonNullCaseDbPointer).imageHandleCache.containsKey(imageKey)) {
                    long tempImageHandle = (Long)HandleCache.getCaseHandles(nonNullCaseDbPointer).imageHandleCache.get(imageKey);
                    HandleCache.getCaseHandles(nonNullCaseDbPointer).fsHandleCache.remove(tempImageHandle);
                    HandleCache.getCaseHandles(nonNullCaseDbPointer).imageHandleCache.remove(imageKey);
                }
                if (useCache && HandleCache.getCaseHandles(nonNullCaseDbPointer).imageHandleCache.containsKey(imageKey)) {
                    imageHandle = (Long)HandleCache.getCaseHandles(nonNullCaseDbPointer).imageHandleCache.get(imageKey);
                } else {
                    imageHandle = SleuthkitJNI.openImgNat(imageFiles, imageFiles.length, sSize);
                    HandleCache.getCaseHandles(nonNullCaseDbPointer).fsHandleCache.put(imageHandle, new HashMap());
                    HandleCache.getCaseHandles(nonNullCaseDbPointer).imageHandleCache.put(imageKey, imageHandle);
                }
            }
            long l = imageHandle;
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openVs(long imgHandle, long vsOffset) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                throw new TskCoreException("Image handle " + imgHandle + " is closed");
            }
            long l = SleuthkitJNI.openVsNat(imgHandle, vsOffset);
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openVsPart(long vsHandle, long volId) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            long l = SleuthkitJNI.openVolNat(vsHandle, volId);
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openFs(long imgHandle, long fsOffset, SleuthkitCase skCase) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            long fsHandle;
            Object object = HandleCache.cacheLock;
            synchronized (object) {
                long caseDbPointer = skCase == null ? HandleCache.getDefaultCaseDbPointer() : skCase.getCaseHandle().caseDbPointer;
                Map imgOffSetToFsHandle = (Map)HandleCache.getCaseHandles(caseDbPointer).fsHandleCache.get(imgHandle);
                if (imgOffSetToFsHandle == null) {
                    throw new TskCoreException("Missing image offset to file system handle cache for image handle " + imgHandle);
                }
                if (imgOffSetToFsHandle.containsKey(fsOffset)) {
                    fsHandle = (Long)imgOffSetToFsHandle.get(fsOffset);
                } else {
                    fsHandle = SleuthkitJNI.openFsNat(imgHandle, fsOffset);
                    imgOffSetToFsHandle.put(fsOffset, fsHandle);
                }
            }
            long l = fsHandle;
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openFile(long fsHandle, long fileId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, SleuthkitCase skCase) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            long fileHandle = SleuthkitJNI.openFileNat(fsHandle, fileId, attrType.getValue(), SleuthkitJNI.convertSignedToUnsigned(attrId));
            Object object = HandleCache.cacheLock;
            synchronized (object) {
                long caseDbPointer = skCase == null ? HandleCache.getDefaultCaseDbPointer() : skCase.getCaseHandle().caseDbPointer;
                HandleCache.addFileHandle(caseDbPointer, fileHandle, fsHandle);
            }
            long l = fileHandle;
            return l;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    private static int convertSignedToUnsigned(int val) {
        if (val >= 0) {
            return val;
        }
        return val & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean imgHandleIsValid(long imgHandle) {
        Object object = HandleCache.cacheLock;
        synchronized (object) {
            return HandleCache.isImageInAnyCache(imgHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readImg(long imgHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                throw new TskCoreException("Image handle " + imgHandle + " is closed");
            }
            int n = SleuthkitJNI.readImgNat(imgHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readVs(long vsHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            int n = SleuthkitJNI.readVsNat(vsHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readVsPart(long volHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            int n = SleuthkitJNI.readVolNat(volHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFs(long fsHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            int n = SleuthkitJNI.readFsNat(fsHandle, readBuffer, offset, len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFile(long fileHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!HandleCache.isValidFileHandle(fileHandle)) {
                throw new TskCoreException("Invalid file handle.");
            }
            int n = SleuthkitJNI.readFileNat(fileHandle, readBuffer, offset, TSK_FS_FILE_READ_OFFSET_TYPE_ENUM.START_OF_FILE.getValue(), len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFileSlack(long fileHandle, byte[] readBuffer, long offset, long len) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!HandleCache.isValidFileHandle(fileHandle)) {
                throw new TskCoreException("Invalid file handle.");
            }
            int n = SleuthkitJNI.readFileNat(fileHandle, readBuffer, offset, TSK_FS_FILE_READ_OFFSET_TYPE_ENUM.START_OF_SLACK.getValue(), len);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static List<String> getFileMetaDataText(long fileHandle) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!HandleCache.isValidFileHandle(fileHandle)) {
                throw new TskCoreException("Invalid file handle.");
            }
            try {
                String line;
                File tmp = File.createTempFile("tsk", ".txt");
                SleuthkitJNI.saveFileMetaDataTextNat(fileHandle, tmp.getAbsolutePath());
                FileReader fr = new FileReader(tmp.getAbsolutePath());
                BufferedReader textReader = new BufferedReader(fr);
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = textReader.readLine()) != null) {
                    lines.add(line);
                }
                textReader.close();
                fr.close();
                tmp.delete();
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            catch (IOException ex) {
                throw new TskCoreException("Error reading istat output: " + ex.getLocalizedMessage());
            }
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static void closeFile(long fileHandle) {
        SleuthkitJNI.closeFile(fileHandle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeFile(long fileHandle, SleuthkitCase skCase) {
        SleuthkitJNI.getTSKReadLock();
        try {
            Object object = HandleCache.cacheLock;
            synchronized (object) {
                block8: {
                    if (HandleCache.isValidFileHandle(fileHandle)) break block8;
                    return;
                }
                SleuthkitJNI.closeFileNat(fileHandle);
                HandleCache.removeFileHandle(fileHandle, skCase);
            }
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static void createLookupIndexForHashDatabase(int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbCreateIndexNat(dbHandle);
    }

    public static boolean hashDatabaseHasLookupIndex(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIndexExistsNat(dbHandle);
    }

    public static boolean hashDatabaseCanBeReindexed(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIsReindexableNat(dbHandle);
    }

    public static String getHashDatabasePath(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbPathNat(dbHandle);
    }

    public static String getHashDatabaseIndexPath(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIndexPathNat(dbHandle);
    }

    public static int openHashDatabase(String path) throws TskCoreException {
        return SleuthkitJNI.hashDbOpenNat(path);
    }

    public static int createHashDatabase(String path) throws TskCoreException {
        return SleuthkitJNI.hashDbNewNat(path);
    }

    public static void closeAllHashDatabases() throws TskCoreException {
        SleuthkitJNI.hashDbCloseAll();
    }

    public static void closeHashDatabase(int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbClose(dbHandle);
    }

    public static String getHashDatabaseDisplayName(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbGetDisplayName(dbHandle);
    }

    public static boolean lookupInHashDatabase(String hash, int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbLookup(hash, dbHandle);
    }

    public static HashHitInfo lookupInHashDatabaseVerbose(String hash, int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbLookupVerbose(hash, dbHandle);
    }

    public static void addToHashDatabase(String filename, String md5, String sha1, String sha256, String comment, int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbAddEntryNat(filename, md5, sha1, sha256, comment, dbHandle);
    }

    public static void addToHashDatabase(List<HashEntry> hashes, int dbHandle) throws TskCoreException {
        SleuthkitJNI.hashDbBeginTransactionNat(dbHandle);
        try {
            for (HashEntry entry : hashes) {
                SleuthkitJNI.hashDbAddEntryNat(entry.getFileName(), entry.getMd5Hash(), entry.getSha1Hash(), entry.getSha256Hash(), entry.getComment(), dbHandle);
            }
            SleuthkitJNI.hashDbCommitTransactionNat(dbHandle);
        }
        catch (TskCoreException ex) {
            try {
                SleuthkitJNI.hashDbRollbackTransactionNat(dbHandle);
            }
            catch (TskCoreException ex2) {
                ex2.initCause(ex);
                throw ex2;
            }
            throw ex;
        }
    }

    public static boolean isUpdateableHashDatabase(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIsUpdateableNat(dbHandle);
    }

    public static boolean hashDatabaseIsIndexOnly(int dbHandle) throws TskCoreException {
        return SleuthkitJNI.hashDbIsIdxOnlyNat(dbHandle);
    }

    private static String timezoneLongToShort(String timezoneLongForm) {
        if (timezoneLongForm == null || timezoneLongForm.isEmpty()) {
            return "";
        }
        TimeZone zone = TimeZone.getTimeZone(timezoneLongForm);
        int offset = zone.getRawOffset() / 1000;
        int hour = offset / 3600;
        int min = offset % 3600 / 60;
        SimpleDateFormat dfm = new SimpleDateFormat("z");
        dfm.setTimeZone(zone);
        boolean hasDaylight = zone.useDaylightTime();
        String first = dfm.format(new GregorianCalendar(2010, 1, 1).getTime()).substring(0, 3);
        String second = dfm.format(new GregorianCalendar(2011, 6, 6).getTime()).substring(0, 3);
        int mid = hour * -1;
        String timezoneShortForm = first + Integer.toString(mid);
        if (min != 0) {
            timezoneShortForm = timezoneShortForm + ":" + (min < 10 ? "0" : "") + Integer.toString(min);
        }
        if (hasDaylight) {
            timezoneShortForm = timezoneShortForm + second;
        }
        return timezoneShortForm;
    }

    public static int finishImageWriter(long imgHandle) throws TskCoreException {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (!SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                throw new TskCoreException("Image handle " + imgHandle + " is closed");
            }
            int n = SleuthkitJNI.finishImageWriterNat(imgHandle);
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static int getFinishImageProgress(long imgHandle) {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                int n = SleuthkitJNI.getFinishImageProgressNat(imgHandle);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static void cancelFinishImage(long imgHandle) {
        SleuthkitJNI.getTSKReadLock();
        try {
            if (SleuthkitJNI.imgHandleIsValid(imgHandle)) {
                SleuthkitJNI.cancelFinishImageNat(imgHandle);
            }
        }
        finally {
            SleuthkitJNI.releaseTSKReadLock();
        }
    }

    public static long findDeviceSize(String devPath) throws TskCoreException {
        return SleuthkitJNI.findDeviceSizeNat(devPath);
    }

    public static boolean isImageSupported(String imagePath) {
        return SleuthkitJNI.isImageSupportedNat(imagePath);
    }

    private static void getTSKReadLock() {
        tskLock.readLock().lock();
    }

    private static void releaseTSKReadLock() {
        tskLock.readLock().unlock();
    }

    @Deprecated
    public static void closeImg(long imgHandle) {
    }

    @Deprecated
    public static void closeVs(long vsHandle) {
    }

    @Deprecated
    public static void closeFs(long fsHandle) {
    }

    @Deprecated
    public static long openImage(String[] imageFiles) throws TskCoreException {
        return SleuthkitJNI.openImage(imageFiles, 0, true, null);
    }

    @Deprecated
    public static long openImage(String[] imageFiles, int sSize) throws TskCoreException {
        return SleuthkitJNI.openImage(imageFiles, sSize, true, null);
    }

    @Deprecated
    public static long openFs(long imgHandle, long fsOffset) throws TskCoreException {
        return SleuthkitJNI.openFs(imgHandle, fsOffset, null);
    }

    @Deprecated
    public static long openFile(long fsHandle, long fileId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId) throws TskCoreException {
        return SleuthkitJNI.openFile(fsHandle, fileId, attrType, attrId, null);
    }

    private static native String getVersionNat();

    private static native void startVerboseLoggingNat(String var0);

    private static native long newCaseDbNat(String var0) throws TskCoreException;

    private static native long newCaseDbMultiNat(String var0, String var1, String var2, String var3, int var4, String var5);

    private static native long openCaseDbMultiNat(String var0, String var1, String var2, String var3, int var4, String var5);

    private static native long openCaseDbNat(String var0) throws TskCoreException;

    private static native void closeCaseDbNat(long var0) throws TskCoreException;

    private static native int hashDbOpenNat(String var0) throws TskCoreException;

    private static native int hashDbNewNat(String var0) throws TskCoreException;

    private static native int hashDbBeginTransactionNat(int var0) throws TskCoreException;

    private static native int hashDbCommitTransactionNat(int var0) throws TskCoreException;

    private static native int hashDbRollbackTransactionNat(int var0) throws TskCoreException;

    private static native int hashDbAddEntryNat(String var0, String var1, String var2, String var3, String var4, int var5) throws TskCoreException;

    private static native boolean hashDbIsUpdateableNat(int var0);

    private static native boolean hashDbIsReindexableNat(int var0);

    private static native String hashDbPathNat(int var0);

    private static native String hashDbIndexPathNat(int var0);

    private static native String hashDbGetDisplayName(int var0) throws TskCoreException;

    private static native void hashDbCloseAll() throws TskCoreException;

    private static native void hashDbClose(int var0) throws TskCoreException;

    private static native void hashDbCreateIndexNat(int var0) throws TskCoreException;

    private static native boolean hashDbIndexExistsNat(int var0) throws TskCoreException;

    private static native boolean hashDbIsIdxOnlyNat(int var0) throws TskCoreException;

    private static native boolean hashDbLookup(String var0, int var1) throws TskCoreException;

    private static native HashHitInfo hashDbLookupVerbose(String var0, int var1) throws TskCoreException;

    private static native long initAddImgNat(long var0, String var2, boolean var3, boolean var4) throws TskCoreException;

    private static native long initializeAddImgNat(long var0, String var2, boolean var3, boolean var4, boolean var5) throws TskCoreException;

    private static native void runOpenAndAddImgNat(long var0, String var2, String[] var3, int var4, String var5) throws TskCoreException, TskDataException;

    private static native void runAddImgNat(long var0, String var2, long var3, String var5, String var6) throws TskCoreException, TskDataException;

    private static native void stopAddImgNat(long var0) throws TskCoreException;

    private static native void revertAddImgNat(long var0) throws TskCoreException;

    private static native long commitAddImgNat(long var0) throws TskCoreException;

    private static native long openImgNat(String[] var0, int var1, int var2) throws TskCoreException;

    private static native long openVsNat(long var0, long var2) throws TskCoreException;

    private static native long openVolNat(long var0, long var2) throws TskCoreException;

    private static native long openFsNat(long var0, long var2) throws TskCoreException;

    private static native long openFileNat(long var0, long var2, int var4, int var5) throws TskCoreException;

    private static native int readImgNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readVsNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readVolNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readFsNat(long var0, byte[] var2, long var3, long var5) throws TskCoreException;

    private static native int readFileNat(long var0, byte[] var2, long var3, int var5, long var6) throws TskCoreException;

    private static native int saveFileMetaDataTextNat(long var0, String var2) throws TskCoreException;

    private static native void closeImgNat(long var0);

    private static native void closeVsNat(long var0);

    private static native void closeFsNat(long var0);

    private static native void closeFileNat(long var0);

    private static native long findDeviceSizeNat(String var0) throws TskCoreException;

    private static native String getCurDirNat(long var0);

    private static native boolean isImageSupportedNat(String var0);

    private static native int finishImageWriterNat(long var0);

    private static native int getFinishImageProgressNat(long var0);

    private static native void cancelFinishImageNat(long var0);

    static {
        LibraryUtils.loadSleuthkitJNI();
    }

    private static enum TSK_FS_FILE_READ_OFFSET_TYPE_ENUM {
        START_OF_FILE(0),
        START_OF_SLACK(1);

        private final int val;

        private TSK_FS_FILE_READ_OFFSET_TYPE_ENUM(int val) {
            this.val = val;
        }

        int getValue() {
            return this.val;
        }
    }

    public static class CaseDbHandle {
        private final long caseDbPointer;

        private CaseDbHandle(long caseDbPointer) {
            this.caseDbPointer = caseDbPointer;
            HandleCache.createCaseHandleCache(caseDbPointer);
        }

        void free() throws TskCoreException {
            tskLock.writeLock().lock();
            try {
                HandleCache.closeHandlesAndClearCache(this.caseDbPointer);
                SleuthkitJNI.closeCaseDbNat(this.caseDbPointer);
            }
            finally {
                tskLock.writeLock().unlock();
            }
        }

        long addImageInfo(long deviceObjId, List<String> imageFilePaths, String timeZone, SleuthkitCase skCase) throws TskCoreException {
            try {
                long tskAutoDbPointer = SleuthkitJNI.initializeAddImgNat(this.caseDbPointer, SleuthkitJNI.timezoneLongToShort(timeZone), false, false, false);
                SleuthkitJNI.runOpenAndAddImgNat(tskAutoDbPointer, UUID.randomUUID().toString(), imageFilePaths.toArray(new String[0]), imageFilePaths.size(), timeZone);
                long id = SleuthkitJNI.commitAddImgNat(tskAutoDbPointer);
                skCase.addDataSourceToHasChildrenMap();
                return id;
            }
            catch (TskDataException ex) {
                throw new TskCoreException("Error adding image to case database", ex);
            }
        }

        AddImageProcess initAddImageProcess(String timeZone, boolean addUnallocSpace, boolean skipFatFsOrphans, String imageCopyPath, SleuthkitCase skCase) {
            return new AddImageProcess(timeZone, addUnallocSpace, skipFatFsOrphans, imageCopyPath, skCase);
        }

        public class AddImageProcess {
            private final String timeZone;
            private final boolean addUnallocSpace;
            private final boolean skipFatFsOrphans;
            private final String imageWriterPath;
            private volatile long tskAutoDbPointer;
            private boolean isCanceled;
            private final SleuthkitCase skCase;

            private AddImageProcess(String timeZone, boolean addUnallocSpace, boolean skipFatFsOrphans, String imageWriterPath, SleuthkitCase skCase) {
                this.timeZone = timeZone;
                this.addUnallocSpace = addUnallocSpace;
                this.skipFatFsOrphans = skipFatFsOrphans;
                this.imageWriterPath = imageWriterPath;
                this.tskAutoDbPointer = 0L;
                this.isCanceled = false;
                this.skCase = skCase;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(String deviceId, String[] imageFilePaths, int sectorSize) throws TskCoreException, TskDataException {
                SleuthkitJNI.getTSKReadLock();
                try {
                    long imageHandle = 0L;
                    AddImageProcess addImageProcess = this;
                    synchronized (addImageProcess) {
                        if (0L != this.tskAutoDbPointer) {
                            throw new TskCoreException("Add image process already started");
                        }
                        if (!this.isCanceled) {
                            imageHandle = SleuthkitJNI.openImage(imageFilePaths, sectorSize, false, CaseDbHandle.this.caseDbPointer);
                            this.tskAutoDbPointer = SleuthkitJNI.initAddImgNat(CaseDbHandle.this.caseDbPointer, SleuthkitJNI.timezoneLongToShort(this.timeZone), this.addUnallocSpace, this.skipFatFsOrphans);
                        }
                        if (0L == this.tskAutoDbPointer) {
                            throw new TskCoreException("initAddImgNat returned a NULL TskAutoDb pointer");
                        }
                    }
                    if (imageHandle != 0L) {
                        SleuthkitJNI.runAddImgNat(this.tskAutoDbPointer, deviceId, imageHandle, this.timeZone, this.imageWriterPath);
                    }
                }
                finally {
                    SleuthkitJNI.releaseTSKReadLock();
                }
            }

            public synchronized void stop() throws TskCoreException {
                SleuthkitJNI.getTSKReadLock();
                try {
                    this.isCanceled = true;
                    if (this.tskAutoDbPointer != 0L) {
                        SleuthkitJNI.stopAddImgNat(this.tskAutoDbPointer);
                    }
                }
                finally {
                    SleuthkitJNI.releaseTSKReadLock();
                }
            }

            public synchronized void revert() throws TskCoreException {
                SleuthkitJNI.getTSKReadLock();
                try {
                    if (this.tskAutoDbPointer == 0L) {
                        throw new TskCoreException("AddImgProcess::revert: AutoDB pointer is NULL");
                    }
                    SleuthkitJNI.revertAddImgNat(this.tskAutoDbPointer);
                    this.tskAutoDbPointer = 0L;
                }
                finally {
                    SleuthkitJNI.releaseTSKReadLock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized long commit() throws TskCoreException {
                SleuthkitJNI.getTSKReadLock();
                try {
                    if (this.tskAutoDbPointer == 0L) {
                        throw new TskCoreException("AddImgProcess::commit: AutoDB pointer is NULL");
                    }
                    long id = SleuthkitJNI.commitAddImgNat(this.tskAutoDbPointer);
                    this.skCase.addDataSourceToHasChildrenMap();
                    this.tskAutoDbPointer = 0L;
                    long l = id;
                    return l;
                }
                finally {
                    SleuthkitJNI.releaseTSKReadLock();
                }
            }

            public synchronized String currentDirectory() {
                return this.tskAutoDbPointer == 0L ? "" : SleuthkitJNI.getCurDirNat(this.tskAutoDbPointer);
            }

            @Deprecated
            public void run(String[] imageFilePaths) throws TskCoreException, TskDataException {
                this.run(null, imageFilePaths, 0);
            }

            public void run(String deviceId, String[] imageFilePaths) throws TskCoreException, TskDataException {
                this.run(deviceId, imageFilePaths, 0);
            }
        }
    }

    private static class HandleCache {
        private static final Object cacheLock = new Object();
        private static final Map<Long, CaseHandles> caseHandlesCache = new HashMap<Long, CaseHandles>();
        private static final String INVALID_FILE_HANDLE = "Invalid file handle.";

        private HandleCache() {
        }

        private static void createCaseHandleCache(long caseDbPointer) {
            caseHandlesCache.put(caseDbPointer, new CaseHandles());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static long getDefaultCaseDbPointer() throws TskCoreException {
            Object object = cacheLock;
            synchronized (object) {
                if (caseHandlesCache.keySet().size() > 1) {
                    throw new TskCoreException("Can not get default case handle with multiple open cases");
                }
                if (caseHandlesCache.keySet().isEmpty()) {
                    throw new TskCoreException("Can not get default case handle with no open case");
                }
                return caseHandlesCache.keySet().iterator().next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static CaseHandles getCaseHandles(long caseDbPointer) {
            Object object = cacheLock;
            synchronized (object) {
                return caseHandlesCache.get(caseDbPointer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void removeCaseHandlesCache(long caseDbPointer) {
            Object object = cacheLock;
            synchronized (object) {
                if (caseHandlesCache.containsKey(caseDbPointer)) {
                    caseHandlesCache.get(caseDbPointer).fsHandleCache.clear();
                    caseHandlesCache.get(caseDbPointer).imageHandleCache.clear();
                    caseHandlesCache.get(caseDbPointer).fileHandleCache.clear();
                    caseHandlesCache.get(caseDbPointer).fileSystemToFileHandles.clear();
                    caseHandlesCache.remove(caseDbPointer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isImageInAnyCache(long imgHandle) {
            Object object = cacheLock;
            synchronized (object) {
                for (long caseDbPointer : caseHandlesCache.keySet()) {
                    if (!caseHandlesCache.get(caseDbPointer).fsHandleCache.keySet().contains(imgHandle)) continue;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addFileHandle(long caseDbPointer, long fileHandle, long fsHandle) {
            Object object = cacheLock;
            synchronized (object) {
                HandleCache.getCaseHandles(caseDbPointer).fileHandleCache.add(fileHandle);
                if (HandleCache.getCaseHandles(caseDbPointer).fileSystemToFileHandles.containsKey(fsHandle)) {
                    ((List)HandleCache.getCaseHandles(caseDbPointer).fileSystemToFileHandles.get(fsHandle)).add(fileHandle);
                } else {
                    HandleCache.getCaseHandles(caseDbPointer).fileSystemToFileHandles.put(fsHandle, new ArrayList<Long>(Arrays.asList(fileHandle)));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void removeFileHandle(long fileHandle, SleuthkitCase skCase) {
            Object object = cacheLock;
            synchronized (object) {
                if (skCase != null) {
                    HandleCache.getCaseHandles(skCase.getCaseHandle().caseDbPointer).fileHandleCache.remove(fileHandle);
                } else {
                    for (long caseDbPointer : caseHandlesCache.keySet()) {
                        if (!caseHandlesCache.get(caseDbPointer).fileHandleCache.contains(fileHandle)) continue;
                        caseHandlesCache.get(caseDbPointer).fileHandleCache.remove(fileHandle);
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isValidFileHandle(long fileHandle) {
            Object object = cacheLock;
            synchronized (object) {
                for (long caseDbPointer : caseHandlesCache.keySet()) {
                    if (!caseHandlesCache.get(caseDbPointer).fileHandleCache.contains(fileHandle)) continue;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void closeHandlesAndClearCache(long caseDbPointer) throws TskCoreException {
            Object object = cacheLock;
            synchronized (object) {
                for (Map imageToFsMap : HandleCache.getCaseHandles(caseDbPointer).fsHandleCache.values()) {
                    for (Long fsHandle : imageToFsMap.values()) {
                        for (Long fileHandle : (List)HandleCache.getCaseHandles(caseDbPointer).fileSystemToFileHandles.get(fsHandle)) {
                            SleuthkitJNI.closeFile(fileHandle);
                        }
                        SleuthkitJNI.closeFsNat(fsHandle);
                    }
                }
                for (Long imageHandle : HandleCache.getCaseHandles(caseDbPointer).imageHandleCache.values()) {
                    SleuthkitJNI.closeImgNat(imageHandle);
                }
                HandleCache.removeCaseHandlesCache(caseDbPointer);
            }
        }
    }

    private static class CaseHandles {
        private final Map<String, Long> imageHandleCache = new HashMap<String, Long>();
        private final Map<Long, Map<Long, Long>> fsHandleCache = new HashMap<Long, Map<Long, Long>>();
        private final Set<Long> fileHandleCache = new HashSet<Long>();
        private final Map<Long, List<Long>> fileSystemToFileHandles = new HashMap<Long, List<Long>>();

        private CaseHandles() {
        }
    }
}

