/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.CollectionUtils;

public final class Relationship {

    public static final class Type {
        private final String displayName;
        private final String typeName;
        private final int typeID;
        public static final Type MESSAGE = new Type("MESSAGE", "Message", 1);
        public static final Type CALL_LOG = new Type("CALL_LOG", "Call Log", 2);
        public static final Type CONTACT = new Type("CONTACT", "Contact", 3);
        private static final HashMap<Type, Set<Integer>> typesToArtifactTypeIDs = new HashMap();
        private static final Set<Type> PREDEFINED_COMMUNICATION_TYPES;

        static Set<Type> getPredefinedCommunicationTypes() {
            return PREDEFINED_COMMUNICATION_TYPES;
        }

        private Type(String name, String displayName, int id) {
            this.typeName = name;
            this.displayName = displayName;
            this.typeID = id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getTypeID() {
            return this.typeID;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.typeName != null ? this.typeName.hashCode() : 0);
            hash = 37 * hash + this.typeID;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Type other = (Type)obj;
            if (this.typeID != other.typeID) {
                return false;
            }
            return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
        }

        public String toString() {
            return "{" + this.getClass().getName() + ": typeID=" + this.typeName + ", displayName=" + this.displayName + ", typeName=" + this.typeName + "}";
        }

        boolean isCreatableFrom(BlackboardArtifact relationshipArtifact) {
            Set<Integer> get = typesToArtifactTypeIDs.get(this);
            return get != null && get.contains(relationshipArtifact.getArtifactTypeID());
        }

        static {
            typesToArtifactTypeIDs.put(MESSAGE, CollectionUtils.hashSetOf(BlackboardArtifact.ARTIFACT_TYPE.TSK_EMAIL_MSG.getTypeID(), BlackboardArtifact.ARTIFACT_TYPE.TSK_MESSAGE.getTypeID()));
            typesToArtifactTypeIDs.put(CALL_LOG, Collections.singleton(BlackboardArtifact.ARTIFACT_TYPE.TSK_CALLLOG.getTypeID()));
            typesToArtifactTypeIDs.put(CONTACT, Collections.singleton(BlackboardArtifact.ARTIFACT_TYPE.TSK_CONTACT.getTypeID()));
            PREDEFINED_COMMUNICATION_TYPES = Collections.unmodifiableSet(new HashSet<Type>(Arrays.asList(MESSAGE, CALL_LOG)));
        }
    }
}

