/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.Account;
import org.sleuthkit.datamodel.AccountDeviceInstance;
import org.sleuthkit.datamodel.AccountFileInstance;
import org.sleuthkit.datamodel.AccountPair;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.CommunicationsFilter;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.Relationship;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.StringUtils;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskDataException;

public final class CommunicationsManager {
    private static final Logger LOGGER = Logger.getLogger(CommunicationsManager.class.getName());
    private final SleuthkitCase db;
    private final Map<Account.Type, Integer> accountTypeToTypeIdMap = new ConcurrentHashMap<Account.Type, Integer>();
    private final Map<String, Account.Type> typeNameToAccountTypeMap = new ConcurrentHashMap<String, Account.Type>();
    private static final Set<Integer> RELATIONSHIP_ARTIFACT_TYPE_IDS = new HashSet<Integer>(Arrays.asList(BlackboardArtifact.ARTIFACT_TYPE.TSK_MESSAGE.getTypeID(), BlackboardArtifact.ARTIFACT_TYPE.TSK_EMAIL_MSG.getTypeID(), BlackboardArtifact.ARTIFACT_TYPE.TSK_CONTACT.getTypeID(), BlackboardArtifact.ARTIFACT_TYPE.TSK_CALLLOG.getTypeID()));
    private static final String RELATIONSHIP_ARTIFACT_TYPE_IDS_CSV_STR = StringUtils.buildCSVString(RELATIONSHIP_ARTIFACT_TYPE_IDS);

    CommunicationsManager(SleuthkitCase skCase) throws TskCoreException {
        this.db = skCase;
        this.initAccountTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAccountTypes() throws TskCoreException {
        block9: {
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            this.db.acquireSingleUserCaseWriteLock();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                int count = this.readAccountTypes();
                if (0 != count) break block9;
                for (Account.Type type : Account.Type.PREDEFINED_ACCOUNT_TYPES) {
                    try {
                        statement.execute("INSERT INTO account_types (type_name, display_name) VALUES ( '" + type.getTypeName() + "', '" + type.getDisplayName() + "')");
                    }
                    catch (SQLException ex) {
                        resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM account_types WHERE type_name = '" + type.getTypeName() + "'");
                        resultSet.next();
                        if (resultSet.getLong("count") == 0L) {
                            throw ex;
                        }
                        resultSet.close();
                    }
                    ResultSet rs2 = connection.executeQuery(statement, "SELECT account_type_id FROM account_types WHERE type_name = '" + type.getTypeName() + "'");
                    rs2.next();
                    int typeID = rs2.getInt("account_type_id");
                    rs2.close();
                    Account.Type accountType = new Account.Type(type.getTypeName(), type.getDisplayName());
                    this.accountTypeToTypeIdMap.put(accountType, typeID);
                    this.typeNameToAccountTypeMap.put(type.getTypeName(), accountType);
                }
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Failed to add row to account_types", ex);
            }
            finally {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.db.releaseSingleUserCaseWriteLock();
            }
        }
    }

    private int readAccountTypes() throws TskCoreException {
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        int count = 0;
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM account_types");
            resultSet.next();
            if (resultSet.getLong("count") > 0L) {
                resultSet.close();
                resultSet = connection.executeQuery(statement, "SELECT * FROM account_types");
                while (resultSet.next()) {
                    Account.Type accountType = new Account.Type(resultSet.getString("type_name"), resultSet.getString("display_name"));
                    this.accountTypeToTypeIdMap.put(accountType, resultSet.getInt("account_type_id"));
                    this.typeNameToAccountTypeMap.put(accountType.getTypeName(), accountType);
                }
                count = this.typeNameToAccountTypeMap.size();
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to read account_types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return count;
    }

    SleuthkitCase getSleuthkitCase() {
        return this.db;
    }

    public Account.Type addAccountType(String accountTypeName, String displayName) throws TskCoreException {
        Account.Type type;
        ResultSet rs;
        Statement s;
        SleuthkitCase.CaseDbConnection connection;
        Account.Type accountType;
        block6: {
            accountType = new Account.Type(accountTypeName, displayName);
            if (this.accountTypeToTypeIdMap.containsKey(accountType)) {
                return accountType;
            }
            connection = this.db.getConnection();
            this.db.acquireSingleUserCaseWriteLock();
            s = null;
            rs = null;
            connection.beginTransaction();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM account_types WHERE type_name = '" + accountTypeName + "'");
            if (rs.next()) break block6;
            rs.close();
            s.execute("INSERT INTO account_types (type_name, display_name) VALUES ( '" + accountTypeName + "', '" + displayName + "')");
            rs = connection.executeQuery(s, "SELECT * FROM account_types WHERE type_name = '" + accountTypeName + "'");
            rs.next();
            int typeID = rs.getInt("account_type_id");
            accountType = new Account.Type(rs.getString("type_name"), rs.getString("display_name"));
            this.accountTypeToTypeIdMap.put(accountType, typeID);
            this.typeNameToAccountTypeMap.put(accountTypeName, accountType);
            connection.commitTransaction();
            Account.Type type2 = accountType;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            connection.close();
            this.db.releaseSingleUserCaseWriteLock();
            return type2;
        }
        try {
            int typeID = rs.getInt("account_type_id");
            accountType = new Account.Type(rs.getString("type_name"), rs.getString("display_name"));
            this.accountTypeToTypeIdMap.put(accountType, typeID);
            type = accountType;
        }
        catch (SQLException ex) {
            try {
                connection.rollbackTransaction();
                throw new TskCoreException("Error adding account type", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseWriteLock();
        return type;
    }

    public AccountFileInstance createAccountFileInstance(Account.Type accountType, String accountUniqueID, String moduleName, Content sourceFile) throws TskCoreException {
        Account account = this.getOrCreateAccount(accountType, this.normalizeAccountID(accountType, accountUniqueID));
        BlackboardArtifact accountArtifact = this.getOrCreateAccountFileInstanceArtifact(accountType, this.normalizeAccountID(accountType, accountUniqueID), moduleName, sourceFile);
        return new AccountFileInstance(accountArtifact, account);
    }

    public Account getAccount(Account.Type accountType, String accountUniqueID) throws TskCoreException {
        Account account = null;
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM accounts WHERE account_type_id = " + this.getAccountTypeId(accountType) + " AND account_unique_identifier = '" + this.normalizeAccountID(accountType, accountUniqueID) + "'");
            if (rs.next()) {
                account = new Account(rs.getInt("account_id"), accountType, rs.getString("account_unique_identifier"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting account type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return account;
    }

    public void addRelationships(AccountFileInstance sender, List<AccountFileInstance> recipients, BlackboardArtifact sourceArtifact, Relationship.Type relationshipType, long dateTime) throws TskCoreException, TskDataException {
        if (!relationshipType.isCreatableFrom(sourceArtifact)) {
            throw new TskDataException("Can not make a " + relationshipType.getDisplayName() + " relationship from a" + sourceArtifact.getDisplayName());
        }
        ArrayList<Long> accountIDs = new ArrayList<Long>();
        if (null != sender) {
            accountIDs.add(sender.getAccount().getAccountID());
            if (sender.getDataSourceObjectID() != sourceArtifact.getDataSourceObjectID()) {
                throw new TskDataException("Sender and relationship are from different data sources :Sender source ID" + sender.getDataSourceObjectID() + " != relationship source ID" + sourceArtifact.getDataSourceObjectID());
            }
        }
        for (AccountFileInstance recipient : recipients) {
            accountIDs.add(recipient.getAccount().getAccountID());
            if (recipient.getDataSourceObjectID() == sourceArtifact.getDataSourceObjectID()) continue;
            throw new TskDataException("Recipient and relationship are from different data sources :Recipient source ID" + recipient.getDataSourceObjectID() + " != relationship source ID" + sourceArtifact.getDataSourceObjectID());
        }
        for (int i = 0; i < accountIDs.size(); ++i) {
            for (int j = i + 1; j < accountIDs.size(); ++j) {
                try {
                    this.addAccountsRelationship((Long)accountIDs.get(i), (Long)accountIDs.get(j), sourceArtifact, relationshipType, dateTime);
                    continue;
                }
                catch (TskCoreException ex) {
                    LOGGER.log(Level.WARNING, "Error adding relationship", ex);
                }
            }
        }
    }

    private Account getOrCreateAccount(Account.Type accountType, String accountUniqueID) throws TskCoreException {
        Account account = this.getAccount(accountType, accountUniqueID);
        if (null == account) {
            String query = " INTO accounts (account_type_id, account_unique_identifier) VALUES ( " + this.getAccountTypeId(accountType) + ", '" + this.normalizeAccountID(accountType, accountUniqueID) + "')";
            switch (this.db.getDatabaseType()) {
                case POSTGRESQL: {
                    query = "INSERT " + query + " ON CONFLICT DO NOTHING";
                    break;
                }
                case SQLITE: {
                    query = "INSERT OR IGNORE " + query;
                    break;
                }
                default: {
                    throw new TskCoreException("Unknown DB Type: " + this.db.getDatabaseType().name());
                }
            }
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            this.db.acquireSingleUserCaseWriteLock();
            Statement s = null;
            ResultSet rs = null;
            try {
                connection.beginTransaction();
                s = connection.createStatement();
                s.execute(query);
                connection.commitTransaction();
                account = this.getAccount(accountType, accountUniqueID);
            }
            catch (SQLException ex) {
                connection.rollbackTransaction();
                throw new TskCoreException("Error adding an account", ex);
            }
            finally {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseWriteLock();
            }
        }
        return account;
    }

    BlackboardArtifact getOrCreateAccountFileInstanceArtifact(Account.Type accountType, String accountUniqueID, String moduleName, Content sourceFile) throws TskCoreException {
        BlackboardArtifact accountArtifact = this.getAccountFileInstanceArtifact(accountType, accountUniqueID, sourceFile);
        if (null != accountArtifact) {
            return accountArtifact;
        }
        accountArtifact = this.db.newBlackboardArtifact(BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT, sourceFile.getId());
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ACCOUNT_TYPE, moduleName, accountType.getTypeName()));
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ID, moduleName, accountUniqueID));
        accountArtifact.addAttributes(attributes);
        return accountArtifact;
    }

    private BlackboardArtifact getAccountFileInstanceArtifact(Account.Type accountType, String accountUniqueID, Content sourceFile) throws TskCoreException {
        BlackboardArtifact accountArtifact = null;
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            String queryStr = "SELECT artifacts.artifact_id AS artifact_id, artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id, artifacts.review_status_id AS review_status_id FROM blackboard_artifacts AS artifacts\tJOIN blackboard_attributes AS attr_account_type\t\tON artifacts.artifact_id = attr_account_type.artifact_id JOIN blackboard_attributes AS attr_account_id\t\tON artifacts.artifact_id = attr_account_id.artifact_id\t\tAND attr_account_id.attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ID.getTypeID() + "\t    AND attr_account_id.value_text = '" + accountUniqueID + "' WHERE artifacts.artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT.getTypeID() + " AND attr_account_type.attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ACCOUNT_TYPE.getTypeID() + " AND attr_account_type.value_text = '" + accountType.getTypeName() + "' AND artifacts.obj_id = " + sourceFile.getId();
            rs = connection.executeQuery(s, queryStr);
            if (rs.next()) {
                BlackboardArtifact.Type bbartType = this.db.getArtifactType(rs.getInt("artifact_type_id"));
                accountArtifact = new BlackboardArtifact(this.db, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), bbartType.getTypeID(), bbartType.getTypeName(), bbartType.getDisplayName(), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id")));
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting account", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return accountArtifact;
    }

    public Account.Type getAccountType(String accountTypeName) throws TskCoreException {
        Account.Type type;
        if (this.typeNameToAccountTypeMap.containsKey(accountTypeName)) {
            return this.typeNameToAccountTypeMap.get(accountTypeName);
        }
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT account_type_id, type_name, display_name, value_type FROM account_types WHERE type_name = '" + accountTypeName + "'");
            Account.Type accountType = null;
            if (rs.next()) {
                accountType = new Account.Type(accountTypeName, rs.getString("display_name"));
                this.accountTypeToTypeIdMap.put(accountType, rs.getInt("account_type_id"));
                this.typeNameToAccountTypeMap.put(accountTypeName, accountType);
            }
            type = accountType;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting account type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return type;
    }

    private void addAccountsRelationship(long account1_id, long account2_id, BlackboardArtifact relationshipaArtifact, Relationship.Type relationshipType, long dateTime) throws TskCoreException {
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseWriteLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            String dateTimeValStr = dateTime > 0L ? Long.toString(dateTime) : "NULL";
            connection.beginTransaction();
            s = connection.createStatement();
            String query = "INTO account_relationships (account1_id, account2_id, relationship_source_obj_id, date_time, relationship_type, data_source_obj_id  ) VALUES ( " + account1_id + ", " + account2_id + ", " + relationshipaArtifact.getId() + ", " + dateTimeValStr + ", " + relationshipType.getTypeID() + ", " + relationshipaArtifact.getDataSourceObjectID() + ")";
            switch (this.db.getDatabaseType()) {
                case POSTGRESQL: {
                    query = "INSERT " + query + " ON CONFLICT DO NOTHING";
                    break;
                }
                case SQLITE: {
                    query = "INSERT OR IGNORE " + query;
                    break;
                }
                default: {
                    throw new TskCoreException("Unknown DB Type: " + this.db.getDatabaseType().name());
                }
            }
            s.execute(query);
            connection.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                connection.rollbackTransaction();
                throw new TskCoreException("Error adding accounts relationship", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseWriteLock();
    }

    public List<AccountDeviceInstance> getAccountDeviceInstancesWithRelationships(CommunicationsFilter filter) throws TskCoreException {
        ArrayList<AccountDeviceInstance> arrayList;
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            HashSet<String> applicableInnerQueryFilters = new HashSet<String>(Arrays.asList(CommunicationsFilter.DateRangeFilter.class.getName(), CommunicationsFilter.DeviceFilter.class.getName(), CommunicationsFilter.RelationshipTypeFilter.class.getName()));
            String innerQueryfilterSQL = this.getCommunicationsFilterSQL(filter, applicableInnerQueryFilters);
            String innerQueryTemplate = " SELECT %1$1s as account_id,\t\t  data_source_obj_id FROM account_relationships as relationships" + (innerQueryfilterSQL.isEmpty() ? "" : " WHERE " + innerQueryfilterSQL);
            String innerQuery1 = String.format(innerQueryTemplate, "account1_id");
            String innerQuery2 = String.format(innerQueryTemplate, "account2_id");
            String combinedInnerQuery = "SELECT count(*) as relationship_count, account_id, data_source_obj_id  FROM ( " + innerQuery1 + " UNION " + innerQuery2 + " ) AS  inner_union GROUP BY account_id, data_source_obj_id";
            HashSet<String> applicableFilters = new HashSet<String>(Arrays.asList(CommunicationsFilter.AccountTypeFilter.class.getName()));
            String filterSQL = this.getCommunicationsFilterSQL(filter, applicableFilters);
            String queryStr = " accounts.account_id AS account_id, accounts.account_unique_identifier AS account_unique_identifier, account_types.type_name AS type_name, relationship_count, data_source_info.device_id AS device_id FROM ( " + combinedInnerQuery + " ) AS account_device_instances JOIN accounts AS accounts\t\tON accounts.account_id = account_device_instances.account_id JOIN account_types AS account_types\t\tON accounts.account_type_id = account_types.account_type_id JOIN data_source_info AS data_source_info\t\tON account_device_instances.data_source_obj_id = data_source_info.obj_id" + (filterSQL.isEmpty() ? "" : " WHERE " + filterSQL);
            switch (this.db.getDatabaseType()) {
                case POSTGRESQL: {
                    queryStr = "SELECT DISTINCT ON ( accounts.account_id, data_source_info.device_id) " + queryStr;
                    break;
                }
                case SQLITE: {
                    queryStr = "SELECT " + queryStr + " GROUP BY accounts.account_id, data_source_info.device_id";
                    break;
                }
                default: {
                    throw new TskCoreException("Unknown DB Type: " + this.db.getDatabaseType().name());
                }
            }
            rs = connection.executeQuery(s, queryStr);
            ArrayList<AccountDeviceInstance> accountDeviceInstances = new ArrayList<AccountDeviceInstance>();
            while (rs.next()) {
                long account_id = rs.getLong("account_id");
                String deviceID = rs.getString("device_id");
                String type_name = rs.getString("type_name");
                String account_unique_identifier = rs.getString("account_unique_identifier");
                Account.Type accountType = this.typeNameToAccountTypeMap.get(type_name);
                Account account = new Account(account_id, accountType, account_unique_identifier);
                accountDeviceInstances.add(new AccountDeviceInstance(account, deviceID));
            }
            arrayList = accountDeviceInstances;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting account device instances. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public Map<AccountPair, Long> getRelationshipCountsPairwise(Set<AccountDeviceInstance> accounts, CommunicationsFilter filter) throws TskCoreException {
        Object type1;
        HashSet<Long> accountIDs = new HashSet<Long>();
        HashSet<String> accountDeviceIDs = new HashSet<String>();
        for (AccountDeviceInstance adi : accounts) {
            accountIDs.add(adi.getAccount().getAccountID());
            accountDeviceIDs.add("'" + adi.getDeviceId() + "'");
        }
        HashSet<String> applicableFilters = new HashSet<String>(Arrays.asList(CommunicationsFilter.DateRangeFilter.class.getName(), CommunicationsFilter.DeviceFilter.class.getName(), CommunicationsFilter.RelationshipTypeFilter.class.getName()));
        String accountIDsCSL = StringUtils.buildCSVString(accountIDs);
        String accountDeviceIDsCSL = StringUtils.buildCSVString(accountDeviceIDs);
        String filterSQL = this.getCommunicationsFilterSQL(filter, applicableFilters);
        String queryString = " SELECT  count(DISTINCT relationships.relationship_source_obj_id) AS count,\t\tdata_source_info.device_id AS device_id,\t\taccounts1.account_id AS account1_id,\t\taccounts1.account_unique_identifier AS account1_unique_identifier,\t\taccount_types1.type_name AS type_name1,\t\taccount_types1.display_name AS display_name1,\t\taccounts2.account_id AS account2_id,\t\taccounts2.account_unique_identifier AS account2_unique_identifier,\t\taccount_types2.type_name AS type_name2,\t\taccount_types2.display_name AS display_name2 FROM account_relationships AS relationships\tJOIN data_source_info AS data_source_info\t\tON relationships.data_source_obj_id = data_source_info.obj_id \tJOIN accounts AS accounts1\t \t\tON accounts1.account_id = relationships.account1_id\tJOIN account_types AS account_types1\t\tON accounts1.account_type_id = account_types1.account_type_id\tJOIN accounts AS accounts2\t \t\tON accounts2.account_id = relationships.account2_id\tJOIN account_types AS account_types2\t\tON accounts2.account_type_id = account_types2.account_type_id WHERE (( relationships.account1_id IN (" + accountIDsCSL + ")) \t\tAND ( relationships.account2_id IN ( " + accountIDsCSL + " ))\t\tAND ( data_source_info.device_id IN (" + accountDeviceIDsCSL + "))) " + (filterSQL.isEmpty() ? "" : " AND " + filterSQL) + "  GROUP BY data_source_info.device_id, \t\taccounts1.account_id, \t\taccount_types1.type_name, \t\taccount_types1.display_name, \t\taccounts2.account_id, \t\taccount_types2.type_name, \t\taccount_types2.display_name";
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        HashMap<AccountPair, Long> results = new HashMap<AccountPair, Long>();
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, queryString);
            while (rs.next()) {
                type1 = new Account.Type(rs.getString("type_name1"), rs.getString("display_name1"));
                AccountDeviceInstance adi1 = new AccountDeviceInstance(new Account(rs.getLong("account1_id"), (Account.Type)type1, rs.getString("account1_unique_identifier")), rs.getString("device_id"));
                Account.Type type2 = new Account.Type(rs.getString("type_name2"), rs.getString("display_name2"));
                AccountDeviceInstance adi2 = new AccountDeviceInstance(new Account(rs.getLong("account2_id"), type2, rs.getString("account2_unique_identifier")), rs.getString("device_id"));
                AccountPair relationshipKey = new AccountPair(adi1, adi2);
                long count = rs.getLong("count");
                Long oldCount = (Long)results.get(relationshipKey);
                if (oldCount != null) {
                    count += oldCount.longValue();
                }
                results.put(relationshipKey, count);
            }
            type1 = results;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting relationships between accounts. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return type1;
    }

    public long getRelationshipSourcesCount(AccountDeviceInstance accountDeviceInstance, CommunicationsFilter filter) throws TskCoreException {
        long l;
        long account_id = accountDeviceInstance.getAccount().getAccountID();
        String datasourceObjIdsCSV = StringUtils.buildCSVString(this.db.getDataSourceObjIds(accountDeviceInstance.getDeviceId()));
        HashSet<String> applicableFilters = new HashSet<String>(Arrays.asList(CommunicationsFilter.RelationshipTypeFilter.class.getName(), CommunicationsFilter.DateRangeFilter.class.getName()));
        String filterSQL = this.getCommunicationsFilterSQL(filter, applicableFilters);
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            String queryStr = "SELECT count(DISTINCT relationships.relationship_source_obj_id) as count \tFROM account_relationships AS relationships WHERE relationships.data_source_obj_id IN ( " + datasourceObjIdsCSV + " ) AND ( relationships.account1_id = " + account_id + "      OR  relationships.account2_id = " + account_id + " )" + (filterSQL.isEmpty() ? "" : " AND " + filterSQL);
            rs = connection.executeQuery(s, queryStr);
            rs.next();
            l = rs.getLong("count");
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting relationships count for account device instance. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return l;
    }

    public Set<Content> getRelationshipSources(Set<AccountDeviceInstance> accountDeviceInstanceList, CommunicationsFilter filter) throws TskCoreException {
        HashSet<Content> hashSet;
        if (accountDeviceInstanceList.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<Long, HashSet<Long>> accountIdToDatasourceObjIdMap = new HashMap<Long, HashSet<Long>>();
        for (AccountDeviceInstance accountDeviceInstance : accountDeviceInstanceList) {
            long l = accountDeviceInstance.getAccount().getAccountID();
            List<Long> dataSourceObjIds = this.db.getDataSourceObjIds(accountDeviceInstance.getDeviceId());
            if (accountIdToDatasourceObjIdMap.containsKey(l)) {
                ((Set)accountIdToDatasourceObjIdMap.get(l)).addAll(dataSourceObjIds);
                continue;
            }
            accountIdToDatasourceObjIdMap.put(l, new HashSet<Long>(dataSourceObjIds));
        }
        ArrayList<String> adiSQLClauses = new ArrayList<String>();
        for (Map.Entry entry : accountIdToDatasourceObjIdMap.entrySet()) {
            Long accountID = (Long)entry.getKey();
            String datasourceObjIdsCSV = StringUtils.buildCSVString((Collection)entry.getValue());
            adiSQLClauses.add("( ( relationships.data_source_obj_id IN ( " + datasourceObjIdsCSV + " ) ) AND ( relationships.account1_id = " + accountID + " OR relationships.account2_id = " + accountID + " ) )");
        }
        String string = StringUtils.joinAsStrings(adiSQLClauses, " OR ");
        HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(CommunicationsFilter.RelationshipTypeFilter.class.getName(), CommunicationsFilter.DateRangeFilter.class.getName()));
        String filterSQL = this.getCommunicationsFilterSQL(filter, hashSet2);
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            String queryStr = "SELECT DISTINCT artifacts.artifact_id AS artifact_id, artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id,  artifacts.artifact_type_id AS artifact_type_id,  artifacts.review_status_id AS review_status_id   FROM blackboard_artifacts as artifacts JOIN account_relationships AS relationships\tON artifacts.artifact_obj_id = relationships.relationship_source_obj_id WHERE (" + string + " )" + (filterSQL.isEmpty() ? "" : " AND (" + filterSQL + " )");
            rs = connection.executeQuery(s, queryStr);
            HashSet<Content> relationshipSources = new HashSet<Content>();
            while (rs.next()) {
                BlackboardArtifact.Type bbartType = this.db.getArtifactType(rs.getInt("artifact_type_id"));
                relationshipSources.add(new BlackboardArtifact(this.db, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), bbartType.getTypeID(), bbartType.getTypeName(), bbartType.getDisplayName(), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            hashSet = relationshipSources;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting relationships for account. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return hashSet;
    }

    public List<AccountDeviceInstance> getRelatedAccountDeviceInstances(AccountDeviceInstance accountDeviceInstance, CommunicationsFilter filter) throws TskCoreException {
        ArrayList<AccountDeviceInstance> arrayList;
        List<Long> dataSourceObjIds = this.getSleuthkitCase().getDataSourceObjIds(accountDeviceInstance.getDeviceId());
        HashSet<String> applicableInnerQueryFilters = new HashSet<String>(Arrays.asList(CommunicationsFilter.DateRangeFilter.class.getName(), CommunicationsFilter.DeviceFilter.class.getName(), CommunicationsFilter.RelationshipTypeFilter.class.getName()));
        String innerQueryfilterSQL = this.getCommunicationsFilterSQL(filter, applicableInnerQueryFilters);
        String innerQueryTemplate = " SELECT %1$1s as account_id,\t\t  data_source_obj_id FROM account_relationships as relationships WHERE %2$1s = " + accountDeviceInstance.getAccount().getAccountID() + " AND data_source_obj_id IN (" + StringUtils.buildCSVString(dataSourceObjIds) + ")" + (innerQueryfilterSQL.isEmpty() ? "" : " AND " + innerQueryfilterSQL);
        String innerQuery1 = String.format(innerQueryTemplate, "account1_id", "account2_id");
        String innerQuery2 = String.format(innerQueryTemplate, "account2_id", "account1_id");
        String combinedInnerQuery = "SELECT account_id, data_source_obj_id  FROM ( " + innerQuery1 + " UNION " + innerQuery2 + " ) AS  inner_union GROUP BY account_id, data_source_obj_id";
        HashSet<String> applicableFilters = new HashSet<String>(Arrays.asList(CommunicationsFilter.AccountTypeFilter.class.getName()));
        String filterSQL = this.getCommunicationsFilterSQL(filter, applicableFilters);
        String queryStr = " accounts.account_id AS account_id, accounts.account_unique_identifier AS account_unique_identifier, account_types.type_name AS type_name, data_source_info.device_id AS device_id FROM ( " + combinedInnerQuery + " ) AS account_device_instances JOIN accounts AS accounts\t\tON accounts.account_id = account_device_instances.account_id JOIN account_types AS account_types\t\tON accounts.account_type_id = account_types.account_type_id JOIN data_source_info AS data_source_info\t\tON account_device_instances.data_source_obj_id = data_source_info.obj_id" + (filterSQL.isEmpty() ? "" : " WHERE " + filterSQL);
        switch (this.db.getDatabaseType()) {
            case POSTGRESQL: {
                queryStr = "SELECT DISTINCT ON ( accounts.account_id, data_source_info.device_id) " + queryStr;
                break;
            }
            case SQLITE: {
                queryStr = "SELECT " + queryStr + " GROUP BY accounts.account_id, data_source_info.device_id";
                break;
            }
            default: {
                throw new TskCoreException("Unknown DB Type: " + this.db.getDatabaseType().name());
            }
        }
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, queryStr);
            ArrayList<AccountDeviceInstance> accountDeviceInstances = new ArrayList<AccountDeviceInstance>();
            while (rs.next()) {
                long account_id = rs.getLong("account_id");
                String deviceID = rs.getString("device_id");
                String type_name = rs.getString("type_name");
                String account_unique_identifier = rs.getString("account_unique_identifier");
                Account.Type accountType = this.typeNameToAccountTypeMap.get(type_name);
                Account account = new Account(account_id, accountType, account_unique_identifier);
                accountDeviceInstances.add(new AccountDeviceInstance(account, deviceID));
            }
            arrayList = accountDeviceInstances;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting account device instances. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<Content> getRelationshipSources(AccountDeviceInstance account1, AccountDeviceInstance account2, CommunicationsFilter filter) throws TskCoreException {
        ArrayList<Content> arrayList;
        HashSet<String> applicableFilters = new HashSet<String>(Arrays.asList(CommunicationsFilter.DateRangeFilter.class.getName(), CommunicationsFilter.DeviceFilter.class.getName(), CommunicationsFilter.RelationshipTypeFilter.class.getName()));
        String filterSQL = this.getCommunicationsFilterSQL(filter, applicableFilters);
        String queryString = "SELECT artifacts.artifact_id AS artifact_id,\t\tartifacts.obj_id AS obj_id,\t\tartifacts.artifact_obj_id AS artifact_obj_id,\t\tartifacts.data_source_obj_id AS data_source_obj_id,\t\tartifacts.artifact_type_id AS artifact_type_id,\t\tartifacts.review_status_id AS review_status_id FROM blackboard_artifacts AS artifacts\tJOIN account_relationships AS relationships\t\tON artifacts.artifact_obj_id = relationships.relationship_source_obj_id WHERE (( relationships.account1_id = " + account1.getAccount().getAccountID() + " AND relationships.account2_id  = " + account2.getAccount().getAccountID() + " ) OR (\t  relationships.account2_id = " + account1.getAccount().getAccountID() + " AND relationships.account1_id =" + account2.getAccount().getAccountID() + " ))" + (filterSQL.isEmpty() ? "" : " AND " + filterSQL);
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        this.db.acquireSingleUserCaseReadLock();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = connection.createStatement();
            rs = connection.executeQuery(s, queryString);
            ArrayList<Content> artifacts = new ArrayList<Content>();
            while (rs.next()) {
                BlackboardArtifact.Type bbartType = this.db.getArtifactType(rs.getInt("artifact_type_id"));
                artifacts.add(new BlackboardArtifact(this.db, rs.getLong("artifact_id"), rs.getLong("obj_id"), rs.getLong("artifact_obj_id"), rs.getLong("data_source_obj_id"), bbartType.getTypeID(), bbartType.getTypeName(), bbartType.getDisplayName(), BlackboardArtifact.ReviewStatus.withID(rs.getInt("review_status_id"))));
            }
            arrayList = artifacts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting relationships between accounts. " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                connection.close();
                this.db.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        connection.close();
        this.db.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    int getAccountTypeId(Account.Type accountType) {
        if (this.accountTypeToTypeIdMap.containsKey(accountType)) {
            return this.accountTypeToTypeIdMap.get(accountType);
        }
        return 0;
    }

    private String normalizeAccountID(Account.Type accountType, String accountUniqueID) {
        String normailzeAccountID = accountUniqueID;
        if (accountType.equals(Account.Type.PHONE)) {
            normailzeAccountID = this.normalizePhoneNum(accountUniqueID);
        } else if (accountType.equals(Account.Type.EMAIL)) {
            normailzeAccountID = this.normalizeEmailAddress(accountUniqueID);
        }
        return normailzeAccountID;
    }

    private String normalizePhoneNum(String phoneNum) {
        String normailzedPhoneNum = phoneNum.replaceAll("\\D", "");
        if (phoneNum.startsWith("+")) {
            normailzedPhoneNum = "+" + normailzedPhoneNum;
        }
        return normailzedPhoneNum;
    }

    private String normalizeEmailAddress(String emailAddress) {
        String normailzedEmailAddr = emailAddress.toLowerCase();
        return normailzedEmailAddr;
    }

    private String getCommunicationsFilterSQL(CommunicationsFilter commFilter, Set<String> applicableFilters) {
        if (null == commFilter || commFilter.getAndFilters().isEmpty()) {
            return "";
        }
        String sqlStr = "";
        StringBuilder sqlSB = new StringBuilder();
        boolean first = true;
        for (CommunicationsFilter.SubFilter subFilter : commFilter.getAndFilters()) {
            String subfilterSQL;
            if (!applicableFilters.contains(subFilter.getClass().getName()) || (subfilterSQL = subFilter.getSQL(this)).isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                sqlSB.append(" AND ");
            }
            sqlSB.append("( ");
            sqlSB.append(subfilterSQL);
            sqlSB.append(" )");
        }
        if (!sqlSB.toString().isEmpty()) {
            sqlStr = "( " + sqlSB.toString() + " )";
        }
        return sqlStr;
    }
}

