/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sleep.engine.CallRequest;
import sleep.engine.ObjectUtilities;
import sleep.engine.Step;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class ObjectAccess
extends Step {
    protected String name;
    protected Class classRef;

    public ObjectAccess(String string, Class clazz) {
        this.name = string;
        this.classRef = clazz;
    }

    public String toString() {
        return "[Object Access]: " + this.classRef + "#" + this.name + "\n";
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        Scalar scalar;
        block18: {
            Object object = null;
            Class<?> clazz = null;
            Scalar scalar2 = null;
            if (this.classRef == null) {
                scalar2 = (Scalar)scriptEnvironment.getCurrentFrame().pop();
                object = scalar2.objectValue();
                if (object == null) {
                    scriptEnvironment.getScriptInstance().fireWarning("Attempted to call a non-static method on a null reference", this.getLineNumber());
                    scriptEnvironment.KillFrame();
                    scriptEnvironment.getCurrentFrame().push(SleepUtils.getEmptyScalar());
                    return null;
                }
                clazz = object.getClass();
            } else {
                clazz = this.classRef;
            }
            if (scalar2 != null && SleepUtils.isFunctionScalar(scalar2)) {
                CallRequest.ClosureCallRequest closureCallRequest = new CallRequest.ClosureCallRequest(scriptEnvironment, this.getLineNumber(), scalar2, this.name);
                closureCallRequest.CallFunction();
                return null;
            }
            if (this.name == null) {
                scriptEnvironment.getScriptInstance().fireWarning("Attempted to query an object with no method/field", this.getLineNumber());
                scriptEnvironment.KillFrame();
                scriptEnvironment.getCurrentFrame().push(SleepUtils.getEmptyScalar());
                return null;
            }
            scalar = SleepUtils.getEmptyScalar();
            Method method = ObjectUtilities.findMethod(clazz, this.name, scriptEnvironment.getCurrentFrame());
            if (method != null && (this.classRef == null || (method.getModifiers() & 8) == 8)) {
                try {
                    method.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MethodCallRequest methodCallRequest = new MethodCallRequest(scriptEnvironment, this.getLineNumber(), method, scalar2, this.name, clazz);
                methodCallRequest.CallFunction();
                return null;
            }
            if (method == null && !scriptEnvironment.getCurrentFrame().isEmpty()) {
                scriptEnvironment.getScriptInstance().fireWarning("there is no method that matches " + this.name + "(" + SleepUtils.describe(scriptEnvironment.getCurrentFrame()) + ") in " + clazz.getName(), this.getLineNumber());
            } else {
                try {
                    Field field;
                    try {
                        field = clazz.getDeclaredField(this.name);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        field = clazz.getField(this.name);
                    }
                    if (field != null) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        scalar = ObjectUtilities.BuildScalar(true, field.get(object));
                        break block18;
                    }
                    scalar = SleepUtils.getEmptyScalar();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    scriptEnvironment.getScriptInstance().fireWarning("no field/method named " + this.name + " in " + clazz, this.getLineNumber());
                }
                catch (IllegalAccessException illegalAccessException) {
                    scriptEnvironment.getScriptInstance().fireWarning("cannot access " + this.name + " in " + clazz + ": " + illegalAccessException.getMessage(), this.getLineNumber());
                }
            }
        }
        scriptEnvironment.FrameResult(scalar);
        return null;
    }

    private static class MethodCallRequest
    extends CallRequest {
        protected Method theMethod;
        protected Scalar scalar;
        protected String name;
        protected Class theClass;

        public MethodCallRequest(ScriptEnvironment scriptEnvironment, int n, Method method, Scalar scalar, String string, Class clazz) {
            super(scriptEnvironment, n);
            this.theMethod = method;
            this.scalar = scalar;
            this.name = string;
            this.theClass = clazz;
        }

        public String getFunctionName() {
            return this.theMethod.toString();
        }

        public String getFrameDescription() {
            return this.theMethod.toString();
        }

        public String formatCall(String string) {
            StringBuffer stringBuffer = new StringBuffer("[");
            if (string != null && string.length() > 0) {
                string = ": " + string;
            }
            if (this.scalar == null) {
                stringBuffer.append(this.theClass.getName() + " " + this.name + string + "]");
            } else {
                stringBuffer.append(SleepUtils.describe(this.scalar) + " " + this.name + string + "]");
            }
            return stringBuffer.toString();
        }

        protected Scalar execute() {
            Object[] objectArray = ObjectUtilities.buildArgumentArray(this.theMethod.getParameterTypes(), this.getScriptEnvironment().getCurrentFrame(), this.getScriptEnvironment().getScriptInstance());
            try {
                return ObjectUtilities.BuildScalar(true, this.theMethod.invoke(this.scalar != null ? this.scalar.objectValue() : null, objectArray));
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null) {
                    this.getScriptEnvironment().flagError(invocationTargetException.getCause());
                }
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                this.getScriptEnvironment().getScriptInstance().fireWarning(ObjectUtilities.buildArgumentErrorMessage(this.theClass, this.name, this.theMethod.getParameterTypes(), objectArray), this.getLineNumber());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.getScriptEnvironment().getScriptInstance().fireWarning("cannot access " + this.name + " in " + this.theClass + ": " + illegalAccessException.getMessage(), this.getLineNumber());
            }
            return SleepUtils.getEmptyScalar();
        }
    }
}

