/*
 * Decompiled with CFR 0.152.
 */
package org.dashnine.sleep;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.dashnine.sleep.SleepScriptEngineFactory;
import sleep.engine.ObjectUtilities;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.YourCodeSucksException;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptLoader;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class SleepScriptEngine
extends AbstractScriptEngine {
    private ScriptEngineFactory factory;
    private ScriptLoader loader = new ScriptLoader();
    private Hashtable sharedEnvironment = new Hashtable();
    private ScriptVariables variables;

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        ScriptInstance scriptInstance = this.compile(string, scriptContext);
        return this.evalScript(scriptInstance, scriptContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        ScriptInstance scriptInstance = this.compile(this.readFully(reader), scriptContext);
        return this.evalScript(scriptInstance, scriptContext);
    }

    private Object evalScript(ScriptInstance scriptInstance, ScriptContext scriptContext) {
        Bindings bindings = scriptContext.getBindings(200);
        if (bindings != null) {
            for (Map.Entry object2 : bindings.entrySet()) {
                scriptInstance.getScriptVariables().putScalar("$" + object2.getKey().toString(), ObjectUtilities.BuildScalar(true, object2.getValue()));
            }
        }
        Bindings bindings2 = scriptContext.getBindings(100);
        HashMap<String, Scalar> hashMap = new HashMap<String, Scalar>();
        if (bindings2 != null) {
            for (Map.Entry entry : bindings2.entrySet()) {
                hashMap.put("$" + entry.getKey().toString(), ObjectUtilities.BuildScalar(true, entry.getValue()));
            }
        }
        if (hashMap.get("$javax.script.filename") != null) {
            scriptInstance.getScriptVariables().putScalar("$__SCRIPT__", (Scalar)hashMap.get("$javax.script.filename"));
        }
        if (hashMap.get("$javax.script.argv") != null) {
            scriptInstance.getScriptVariables().putScalar("@ARGV", (Scalar)hashMap.get("$javax.script.argv"));
        }
        return SleepUtils.runCode(scriptInstance.getRunnableScript(), "eval", scriptInstance, SleepUtils.getArgumentStack(hashMap)).objectValue();
    }

    private ScriptInstance compile(String string, ScriptContext scriptContext) throws ScriptException {
        try {
            ScriptInstance scriptInstance = this.loader.loadScript("eval", string, this.sharedEnvironment);
            scriptInstance.addWarningWatcher(new WarningWatcher(scriptContext));
            return scriptInstance;
        }
        catch (YourCodeSucksException yourCodeSucksException) {
            throw new ScriptException(yourCodeSucksException.formatErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        SleepScriptEngine sleepScriptEngine = this;
        synchronized (sleepScriptEngine) {
            if (this.factory == null) {
                this.factory = new SleepScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory scriptEngineFactory) {
        this.factory = scriptEngineFactory;
    }

    private String readFully(Reader reader) throws ScriptException {
        StringBuffer stringBuffer = new StringBuffer(8192);
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append("\n");
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static class WarningWatcher
    implements RuntimeWarningWatcher {
        protected ScriptContext context;

        public WarningWatcher(ScriptContext scriptContext) {
            this.context = scriptContext;
        }

        @Override
        public void processScriptWarning(ScriptWarning scriptWarning) {
            System.out.println(scriptWarning.toString());
        }
    }
}

