/*
 * Decompiled with CFR 0.152.
 */
package table;

import graph.GraphPopup;
import graph.Refreshable;
import graph.Route;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import table.GenericTableModel;
import ui.ATable;

public class NetworkTable
extends JComponent
implements ActionListener,
Refreshable {
    protected JScrollPane scroller = null;
    protected boolean isAlive = true;
    protected GraphPopup popup = null;
    protected GenericTableModel model;
    protected JTable table;
    protected int height;
    protected LinkedList rows = new LinkedList();
    protected Properties display;
    protected float zoom = 1.0f;

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public Image getScreenshot() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 6);
        Graphics g = image.getGraphics();
        this.paint(g);
        g.dispose();
        return image;
    }

    public void setGraphPopup(GraphPopup popup) {
        this.popup = popup;
    }

    public NetworkTable() {
        this(new Properties());
    }

    public NetworkTable(Properties display) {
        this.display = display;
        this.model = new GenericTableModel(new String[]{" ", "Address", "Label", "Description", "Pivot"}, "Address", 256);
        this.table = new ATable(this.model);
        TableRowSorter<GenericTableModel> sorter = new TableRowSorter<GenericTableModel>(this.model);
        sorter.toggleSortOrder(1);
        Comparator hostCompare = new Comparator(){

            public int compare(Object a, Object b) {
                long bb;
                long aa = Route.ipToLong(a + "");
                if (aa > (bb = Route.ipToLong(b + ""))) {
                    return 1;
                }
                if (aa < bb) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object a, Object b) {
                return (a + "").equals(b + "");
            }
        };
        sorter.setComparator(1, hostCompare);
        sorter.setComparator(4, hostCompare);
        this.table.setRowSorter(sorter);
        this.table.setColumnSelectionAllowed(false);
        this.setupWidths();
        this.height = this.table.getRowHeight();
        final TableCellRenderer parent = this.table.getDefaultRenderer(Object.class);
        TableCellRenderer phear = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JLabel component = (JLabel)parent.getTableCellRendererComponent(table, value, isSelected, false, row, col);
                float size = component.getFont().getSize2D() * NetworkTable.this.zoom;
                if (col == 4 && Boolean.TRUE.equals(NetworkTable.this.model.getValueAt(table, row, "Active"))) {
                    component.setFont(component.getFont().deriveFont(1).deriveFont(size));
                } else if (col == 1 && !"".equals(NetworkTable.this.model.getValueAt(table, row, "Description"))) {
                    component.setFont(component.getFont().deriveFont(1).deriveFont(size));
                } else {
                    component.setFont(component.getFont().deriveFont(0).deriveFont(size));
                }
                String tip = NetworkTable.this.model.getValueAt(table, row, "Tooltip") + "";
                if (tip.length() > 0) {
                    component.setToolTipText(tip);
                }
                return component;
            }
        };
        this.table.getColumn("Address").setCellRenderer(phear);
        this.table.getColumn("Label").setCellRenderer(phear);
        this.table.getColumn("Description").setCellRenderer(phear);
        this.table.getColumn("Pivot").setCellRenderer(phear);
        this.table.getColumn(" ").setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JLabel component = (JLabel)parent.getTableCellRendererComponent(table, value, isSelected, false, row, col);
                Image original = (Image)NetworkTable.this.model.getImageAt(table, row, "Image", NetworkTable.this.zoom);
                component.setIcon(new ImageIcon(original));
                component.setText("");
                String tip = NetworkTable.this.model.getValueAt(table, row, "Tooltip") + "";
                if (tip.length() > 0) {
                    component.setToolTipText(tip);
                }
                return component;
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void all(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    NetworkTable.this.popup.showGraphPopup(NetworkTable.this.getSelectedHosts(), ev);
                    ev.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                this.all(ev);
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                this.all(ev);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                this.all(ev);
            }
        });
        this.setLayout(new BorderLayout());
        this.scroller = new JScrollPane(this.table);
        this.add((Component)this.scroller, "Center");
        this.setupShortcuts();
    }

    public void setupWidths() {
        this.table.getColumn("Address").setPreferredWidth((int)(125.0f * this.zoom));
        this.table.getColumn("Label").setPreferredWidth((int)(125.0f * this.zoom));
        this.table.getColumn("Pivot").setPreferredWidth((int)(125.0f * this.zoom));
        this.table.getColumn(" ").setPreferredWidth((int)(32.0f * this.zoom));
        this.table.getColumn(" ").setMaxWidth((int)(32.0f * this.zoom));
        this.table.getColumn("Description").setPreferredWidth((int)(500.0f * this.zoom));
    }

    @Override
    public void setTransferHandler(TransferHandler t) {
        this.table.setTransferHandler(t);
    }

    @Override
    public void start() {
    }

    public void fixSelection(int[] rows) {
        if (rows.length == 0) {
            return;
        }
        this.table.getSelectionModel().setValueIsAdjusting(true);
        int rowcount = this.table.getModel().getRowCount();
        for (int x = 0; x < rows.length; ++x) {
            if (rows[x] >= rowcount) continue;
            this.table.getSelectionModel().addSelectionInterval(rows[x], rows[x]);
        }
        this.table.getSelectionModel().setValueIsAdjusting(false);
    }

    @Override
    public void end() {
        final int[] selected = this.table.getSelectedRows();
        this.model.clear(this.rows.size());
        Iterator i = this.rows.iterator();
        while (i.hasNext()) {
            this.model.addEntry((Map)i.next());
        }
        this.rows.clear();
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkTable.this.model.fireListeners();
                    NetworkTable.this.fixSelection(selected);
                }
            });
        } else {
            this.model.fireListeners();
            this.fixSelection(selected);
        }
    }

    @Override
    public void deleteNodes() {
    }

    @Override
    public void highlightRoute(String src, String dst) {
        for (Map temp : this.rows) {
            if (!temp.get("Address").equals(dst) || !temp.get("Pivot").equals(src)) continue;
            temp.put("Active", Boolean.TRUE);
        }
    }

    @Override
    public void setRoutes(Route[] routes) {
        for (Map temp : this.rows) {
            for (int x = 0; x < routes.length; ++x) {
                Route r = routes[x];
                if (!r.shouldRoute(temp.get("Address") + "")) continue;
                temp.put("Pivot", r.getGateway());
            }
        }
    }

    public String getCellAt(Point p) {
        String[] x = this.getSelectedHosts();
        if (x.length > 0) {
            return x[0];
        }
        return null;
    }

    public String[] getSelectedHosts() {
        Object[] sels = this.model.getSelectedValues(this.table);
        String[] vals = new String[sels.length];
        for (int x = 0; x < sels.length; ++x) {
            vals[x] = sels[x] + "";
        }
        return vals;
    }

    public void setAutoLayout(String layout) {
    }

    @Override
    public Object addNode(String id, String label, String description, Image image, String tooltip) {
        if (id == null || label == null) {
            return null;
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("Address", id);
        if (description.indexOf(id) > -1) {
            description = description.substring(id.length());
        }
        map2.put("Label", label);
        map2.put("Description", description);
        map2.put("Tooltip", tooltip);
        map2.put("Image", image);
        map2.put(" ", tooltip);
        map2.put("Pivot", "");
        map2.put("Active", Boolean.FALSE);
        this.rows.add(map2);
        return map2;
    }

    public void zoom(double factor) {
        this.zoom = factor == 0.0 ? 1.0f : (float)((double)this.zoom + factor);
        this.table.setRowHeight((int)Math.ceil((float)this.height * this.zoom));
        this.table.getColumn("Address").setPreferredWidth((int)(125.0f * this.zoom));
        this.table.getColumn(" ").setMaxWidth((int)(32.0f * this.zoom));
        this.table.getColumn(" ").setPreferredWidth((int)(32.0f * this.zoom));
        this.validate();
    }

    private void setupShortcuts() {
        this.addActionForKeySetting("graph.zoom_in.shortcut", "ctrl pressed EQUALS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkTable.this.zoom(0.1);
            }
        });
        this.addActionForKeySetting("graph.zoom_out.shortcut", "ctrl pressed MINUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkTable.this.zoom(-0.1);
            }
        });
        this.addActionForKeySetting("graph.zoom_reset.shortcut", "ctrl pressed 0", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkTable.this.zoom(0.0);
            }
        });
    }

    public void addActionForKeyStroke(KeyStroke key, Action action) {
        this.table.getActionMap().put(key.toString(), action);
        this.table.getInputMap().put(key, key.toString());
    }

    public void addActionForKey(String key, Action action) {
        this.addActionForKeyStroke(KeyStroke.getKeyStroke(key), action);
    }

    public void addActionForKeySetting(String key, String dvalue, Action action) {
        KeyStroke temp = KeyStroke.getKeyStroke(this.display.getProperty(key, dvalue));
        if (temp != null) {
            this.addActionForKeyStroke(temp, action);
        }
    }
}

