/*
 * Decompiled with CFR 0.152.
 */
package cortana;

import cortana.Cortana;
import cortana.CortanaPipe;
import cortana.Loader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import msf.MeterpreterSession;
import msf.RpcConnection;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.runtime.SleepUtils;

public class Main
implements Runnable,
CortanaPipe.CortanaPipeListener {
    protected Cortana engine = null;

    public static Object[] setupConnections(String host, String port, String user, String pass, String nick) {
        Loader loader = new Loader(new RuntimeWarningWatcher(){

            @Override
            public void processScriptWarning(ScriptWarning warning) {
                System.err.println(warning);
            }
        });
        loader.setGlobal("$loader", SleepUtils.getScalar(loader));
        loader.setGlobal("$host", SleepUtils.getScalar(host));
        loader.setGlobal("$port", SleepUtils.getScalar(port));
        loader.setGlobal("$user", SleepUtils.getScalar(user));
        loader.setGlobal("$pass", SleepUtils.getScalar(pass));
        loader.setGlobal("$nick", SleepUtils.getScalar(nick));
        loader.loadInternalScript("scripts/util.sl", null);
        loader.loadInternalScript("scripts/jobs.sl", null);
        loader.loadInternalScript("scripts/preferences.sl", null);
        loader.loadInternalScript("scripts-cortana/cortanadb.sl", null);
        while (!loader.isReady()) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception ex) {}
        }
        return loader.getPassedObjects();
    }

    @Override
    public void run() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    String entry;
                    if ((entry = in.readLine()) == null || "".equals(entry)) {
                        continue;
                    }
                    this.engine.processCommand(entry);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public void start(String host, String port, String user, String pass, String nick, String[] scripts) {
        try {
            Object[] conns = Main.setupConnections(host, port, user, pass, nick);
            this.engine = new Cortana((RpcConnection)conns[0], (RpcConnection)conns[1], scripts, (String)conns[2], Integer.parseInt(conns[3] + ""));
            new Thread(this).start();
        }
        catch (RuntimeException rex) {
            if (rex.getCause() != null) {
                System.err.println(rex.getCause().getMessage());
            } else {
                rex.printStackTrace();
            }
            System.exit(1);
        }
    }

    @Override
    public void read(String text) {
        System.out.println(text);
    }

    public static void main(String[] args) {
        MeterpreterSession.DEFAULT_WAIT = 20000L;
        if (args.length >= 1) {
            try {
                Properties temp = new Properties();
                temp.load(new FileInputStream(args[0]));
                String[] argz = new String[]{temp.getProperty("host"), temp.getProperty("port"), temp.getProperty("user"), temp.getProperty("pass"), temp.getProperty("nick")};
                String[] scripts = new String[args.length - 1];
                for (int x = 1; x < args.length; ++x) {
                    scripts[x - 1] = args[x];
                }
                Main cortanaEngine = new Main();
                cortanaEngine.start(argz[0], argz[1], argz[2], argz[3], argz[4], scripts);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                System.exit(1);
            }
            return;
        }
        Main.showHelp();
    }

    public static void showHelp() {
        System.err.println("java -jar cortana.jar [connection.prop] [script] ... [script n]\n");
        System.err.println("\tCortana is a client for the Metasploit framework. You");
        System.err.println("\tmust provide the details to connect to a running Metasploit");
        System.err.println("\tinstance.");
    }
}

