/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.interfaces.Function;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public abstract class CallRequest {
    protected ScriptEnvironment environment;
    protected int lineNumber;

    public CallRequest(ScriptEnvironment scriptEnvironment, int n) {
        this.environment = scriptEnvironment;
        this.lineNumber = n;
    }

    protected ScriptEnvironment getScriptEnvironment() {
        return this.environment;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public abstract String getFunctionName();

    public abstract String getFrameDescription();

    protected abstract Scalar execute();

    protected abstract String formatCall(String var1);

    public boolean isDebug() {
        return (this.getScriptEnvironment().getScriptInstance().getDebugFlags() & 8) == 8;
    }

    /*
     * Unable to fully structure code
     */
    public void CallFunction() {
        block17: {
            var1_1 = null;
            var2_2 = this.getScriptEnvironment();
            var3_3 = this.getScriptEnvironment().markFrame();
            if (this.isDebug() && this.getLineNumber() != -2147483648) {
                if (var2_2.getScriptInstance().isProfileOnly()) {
                    try {
                        var4_4 = var2_2.getScriptInstance().total();
                        var6_9 = System.currentTimeMillis();
                        var1_1 = this.execute();
                        var6_9 = System.currentTimeMillis() - var6_9 - (var2_2.getScriptInstance().total() - var4_4);
                        var2_2.getScriptInstance().collect(this.getFunctionName(), this.getLineNumber(), var6_9);
                    }
                    catch (RuntimeException var4_5) {
                        if (var4_5.getCause() != null && InvocationTargetException.class.isInstance(var4_5.getCause())) ** GOTO lbl50
                        var2_2.cleanFrame(var3_3);
                        var2_2.KillFrame();
                        throw var4_5;
                    }
                } else {
                    var4_6 = SleepUtils.describe(var2_2.getCurrentFrame());
                    try {
                        var5_12 = var2_2.getScriptInstance().total();
                        var7_15 = System.currentTimeMillis();
                        var1_1 = this.execute();
                        var7_15 = System.currentTimeMillis() - var7_15 - (var2_2.getScriptInstance().total() - var5_12);
                        var2_2.getScriptInstance().collect(this.getFunctionName(), this.getLineNumber(), var7_15);
                        if (var2_2.isThrownValue()) {
                            var2_2.getScriptInstance().fireWarning(this.formatCall(var4_6) + " - FAILED!", this.getLineNumber(), true);
                        }
                        if (var2_2.isPassControl()) {
                            var2_2.getScriptInstance().fireWarning(this.formatCall(var4_6) + " -goto- " + SleepUtils.describe(var1_1), this.getLineNumber(), true);
                        }
                        if (SleepUtils.isEmptyScalar(var1_1)) {
                            var2_2.getScriptInstance().fireWarning(this.formatCall(var4_6), this.getLineNumber(), true);
                        }
                        var2_2.getScriptInstance().fireWarning(this.formatCall(var4_6) + " = " + SleepUtils.describe(var1_1), this.getLineNumber(), true);
                    }
                    catch (RuntimeException var5_13) {
                        var2_2.getScriptInstance().fireWarning(this.formatCall(var4_6) + " - FAILED!", this.getLineNumber(), true);
                        if (var5_13.getCause() != null && InvocationTargetException.class.isInstance(var5_13.getCause())) ** GOTO lbl50
                        var2_2.cleanFrame(var3_3);
                        var2_2.KillFrame();
                        throw var5_13;
                    }
                }
            } else {
                try {
                    var1_1 = this.execute();
                }
                catch (RuntimeException var4_7) {
                    if (var4_7.getCause() != null && InvocationTargetException.class.isInstance(var4_7.getCause())) break block17;
                    var2_2.cleanFrame(var3_3);
                    var2_2.KillFrame();
                    throw var4_7;
                }
            }
        }
        if (var2_2.isThrownValue()) {
            var2_2.getScriptInstance().recordStackFrame(this.getFrameDescription(), this.getLineNumber());
        }
        if (var1_1 == null) {
            var1_1 = SleepUtils.getEmptyScalar();
        }
        var2_2.cleanFrame(var3_3);
        var2_2.FrameResult(var1_1);
        if (var2_2.isPassControl()) {
            var4_8 = var1_1;
            var2_2.pushSource(((SleepClosure)var4_8.objectValue()).getAndRemoveMetadata("sourceFile", "<unknown>") + "");
            var5_14 = (Integer)((SleepClosure)var4_8.objectValue()).getAndRemoveMetadata("sourceLine", new Integer(-1));
            if (var2_2.markFrame() >= 0 && (var6_10 = var2_2.getCurrentFrame().pop()) != var1_1) {
                var2_2.getScriptInstance().fireWarning("bad callcc stack: " + SleepUtils.describe((Scalar)var6_10) + " expected " + SleepUtils.describe(var1_1), var5_14);
            }
            var2_2.flagReturn(null, 0);
            var2_2.CreateFrame();
            var2_2.getCurrentFrame().push(((SleepClosure)var4_8.objectValue()).getAndRemoveMetadata("continuation", null));
            var6_11 = new ClosureCallRequest(this.environment, var5_14, var4_8, "CALLCC");
            var6_11.CallFunction();
            var2_2.popSource();
        }
    }

    public static class InlineCallRequest
    extends CallRequest {
        protected String function;
        protected Block inline;

        public InlineCallRequest(ScriptEnvironment scriptEnvironment, int n, String string, Block block) {
            super(scriptEnvironment, n);
            this.function = string;
            this.inline = block;
        }

        public String getFunctionName() {
            return "<inline> " + this.function;
        }

        public String getFrameDescription() {
            return "<inline> " + this.function + "()";
        }

        protected String formatCall(String string) {
            return "<inline> " + this.function + "(" + string + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Scalar execute() {
            ScriptVariables scriptVariables;
            ScriptVariables scriptVariables2 = scriptVariables = this.getScriptEnvironment().getScriptVariables();
            synchronized (scriptVariables2) {
                Variable variable = scriptVariables.getLocalVariables();
                Scalar scalar = variable.getScalar("@_");
                int n = BridgeUtilities.initLocalScope(scriptVariables, variable, this.getScriptEnvironment().getCurrentFrame());
                Scalar scalar2 = this.inline.evaluate(this.getScriptEnvironment());
                if (scalar != null && scalar.getArray() != null) {
                    variable.putScalar("@_", scalar);
                    if (n > 0) {
                        Iterator iterator = scalar.getArray().scalarIterator();
                        for (int i = 1; iterator.hasNext() && i <= n; ++i) {
                            Scalar scalar3 = (Scalar)iterator.next();
                            variable.putScalar("$" + i, scalar3);
                        }
                    }
                }
                return scalar2;
            }
        }
    }

    public static class FunctionCallRequest
    extends CallRequest {
        protected String function;
        protected Function callme;

        public FunctionCallRequest(ScriptEnvironment scriptEnvironment, int n, String string, Function function2) {
            super(scriptEnvironment, n);
            this.function = string;
            this.callme = function2;
        }

        public String getFunctionName() {
            return this.function;
        }

        public String getFrameDescription() {
            return this.function + "()";
        }

        public String formatCall(String string) {
            return this.function + "(" + string + ")";
        }

        public boolean isDebug() {
            return super.isDebug() && !this.function.equals("&@") && !this.function.equals("&%") && !this.function.equals("&warn");
        }

        protected Scalar execute() {
            Scalar scalar = this.callme.evaluate(this.function, this.getScriptEnvironment().getScriptInstance(), this.getScriptEnvironment().getCurrentFrame());
            this.getScriptEnvironment().clearReturn();
            return scalar;
        }
    }

    public static class ClosureCallRequest
    extends CallRequest {
        protected String name;
        protected Scalar scalar;

        public ClosureCallRequest(ScriptEnvironment scriptEnvironment, int n, Scalar scalar, String string) {
            super(scriptEnvironment, n);
            this.scalar = scalar;
            this.name = string;
        }

        public String getFunctionName() {
            return ((SleepClosure)this.scalar.objectValue()).toStringGeneric();
        }

        public String getFrameDescription() {
            return this.scalar.toString();
        }

        public String formatCall(String string) {
            StringBuffer stringBuffer = new StringBuffer("[" + SleepUtils.describe(this.scalar));
            if (this.name != null && this.name.length() > 0) {
                stringBuffer.append(" " + this.name);
            }
            if (string.length() > 0) {
                stringBuffer.append(": " + string);
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        protected Scalar execute() {
            SleepClosure sleepClosure = SleepUtils.getFunctionFromScalar(this.scalar, this.getScriptEnvironment().getScriptInstance());
            Scalar scalar = sleepClosure.evaluate(this.name, this.getScriptEnvironment().getScriptInstance(), this.getScriptEnvironment().getCurrentFrame());
            this.getScriptEnvironment().clearReturn();
            return scalar;
        }
    }
}

