/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import sleep.engine.Block;
import sleep.engine.Step;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Environment;
import sleep.interfaces.FilterEnvironment;
import sleep.interfaces.Function;
import sleep.interfaces.Operator;
import sleep.interfaces.Predicate;
import sleep.interfaces.PredicateEnvironment;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ScriptEnvironment
implements Serializable {
    protected ScriptInstance self;
    protected Stack environmentStack;
    protected Hashtable environment;
    protected Object errorMessage = null;
    protected Stack context = new Stack();
    protected Stack contextStack = new Stack();
    protected HashMap metadata = new HashMap();
    protected Stack metaStack = new Stack();
    protected ExceptionContext currentHandler = null;
    protected Stack exhandlers = new Stack();
    protected boolean moreHandlers = false;
    public static final int FLOW_CONTROL_NONE = 0;
    public static final int FLOW_CONTROL_RETURN = 1;
    public static final int FLOW_CONTROL_BREAK = 2;
    public static final int FLOW_CONTROL_CONTINUE = 4;
    public static final int FLOW_CONTROL_YIELD = 8;
    public static final int FLOW_CONTROL_THROW = 16;
    public static final int FLOW_CONTROL_DEBUG = 32;
    public static final int FLOW_CONTROL_CALLCC = 72;
    public static final int FLOW_CONTROL_PASS = 128;
    protected String debugString = "";
    protected Scalar rv = null;
    protected int request = 0;
    protected Stack sources = new Stack();
    protected ArrayList frames = new ArrayList(10);
    protected int findex = -1;

    public ScriptEnvironment() {
        this.self = null;
        this.environment = null;
        this.environmentStack = new Stack();
    }

    public ScriptEnvironment(Hashtable hashtable, ScriptInstance scriptInstance) {
        this.self = scriptInstance;
        this.environment = hashtable;
        this.environmentStack = new Stack();
    }

    public ScriptInstance getScriptInstance() {
        return this.self;
    }

    public void flagError(Object object) {
        this.errorMessage = object;
        if ((this.getScriptInstance().getDebugFlags() & 2) == 2) {
            if ((this.getScriptInstance().getDebugFlags() & 0x22) == 34) {
                this.flagReturn(this.checkError(), 16);
            } else {
                this.showDebugMessage("checkError(): " + object);
            }
        }
    }

    public Scalar checkError() {
        Scalar scalar = SleepUtils.getScalar(this.errorMessage);
        this.errorMessage = null;
        return scalar;
    }

    public ScriptVariables getScriptVariables() {
        return this.getScriptInstance().getScriptVariables();
    }

    public Scalar getScalar(String string) {
        return this.getScriptVariables().getScalar(string, this.getScriptInstance());
    }

    public void putScalar(String string, Scalar scalar) {
        this.getScriptVariables().putScalar(string, scalar);
    }

    public Block getBlock(String string) {
        return (Block)this.getEnvironment().get("^" + string);
    }

    public Function getFunction(String string) {
        return (Function)this.getEnvironment().get(string);
    }

    public Environment getFunctionEnvironment(String string) {
        return (Environment)this.getEnvironment().get(string);
    }

    public PredicateEnvironment getPredicateEnvironment(String string) {
        return (PredicateEnvironment)this.getEnvironment().get(string);
    }

    public FilterEnvironment getFilterEnvironment(String string) {
        return (FilterEnvironment)this.getEnvironment().get(string);
    }

    public Predicate getPredicate(String string) {
        return (Predicate)this.getEnvironment().get(string);
    }

    public Operator getOperator(String string) {
        return (Operator)this.getEnvironment().get(string);
    }

    public Hashtable getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Hashtable hashtable) {
        this.environment = hashtable;
    }

    public Stack getEnvironmentStack() {
        return this.environmentStack;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ScriptInstance -- " + this.getScriptInstance());
        stringBuffer.append("Misc Environment:\n");
        stringBuffer.append(this.getEnvironment().toString());
        stringBuffer.append("\nEnvironment Stack:\n");
        stringBuffer.append(this.getEnvironmentStack().toString());
        stringBuffer.append("Return Stuff: " + this.rv);
        return stringBuffer.toString();
    }

    public void loadContext(Stack stack, HashMap hashMap) {
        this.contextStack.push(this.context);
        this.metaStack.push(this.metadata);
        this.context = stack;
        this.metadata = hashMap;
    }

    public void setContextMetadata(Object object, Object object2) {
        if (object2 == null) {
            this.metadata.remove(object);
        } else {
            this.metadata.put(object, object2);
        }
    }

    public Object getContextMetadata(Object object) {
        return this.metadata.get(object);
    }

    public Object getContextMetadata(Object object, Object object2) {
        Object v = this.metadata.get(object);
        if (v == null) {
            return object2;
        }
        return this.metadata.get(object);
    }

    public void addToContext(Block block, Step step) {
        Context context = new Context();
        context.block = block;
        context.last = step;
        if (this.isResponsible(block)) {
            context.handler = this.popExceptionContext();
            Iterator iterator = this.context.iterator();
            while (iterator.hasNext()) {
                Context context2 = (Context)iterator.next();
                context2.moreHandlers = true;
            }
        } else {
            context.moreHandlers = this.moreHandlers;
        }
        this.context.add(context);
    }

    public Scalar evaluateOldContext() {
        Scalar scalar = SleepUtils.getEmptyScalar();
        Stack stack = this.context;
        this.context = new Stack();
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            if (context.handler != null) {
                this.installExceptionHandler(context.handler);
            }
            this.moreHandlers = context.moreHandlers;
            scalar = context.block.evaluate(this, context.last);
            if (!this.isReturn() || !this.isYield()) continue;
            while (iterator.hasNext()) {
                this.context.add(iterator.next());
            }
        }
        this.moreHandlers = false;
        return scalar;
    }

    public Stack saveContext() {
        Stack stack = this.context;
        this.context = (Stack)this.contextStack.pop();
        this.metadata = (HashMap)this.metaStack.pop();
        return stack;
    }

    public boolean isExceptionHandlerInstalled() {
        return this.currentHandler != null || this.moreHandlers;
    }

    public boolean isResponsible(Block block) {
        return this.currentHandler != null && this.currentHandler.owner == block;
    }

    public void installExceptionHandler(ExceptionContext exceptionContext) {
        if (this.currentHandler != null) {
            this.exhandlers.push(this.currentHandler);
        }
        this.currentHandler = exceptionContext;
    }

    public void installExceptionHandler(Block block, Block block2, String string) {
        ExceptionContext exceptionContext = new ExceptionContext();
        exceptionContext.owner = block;
        exceptionContext.handler = block2;
        exceptionContext.varname = string;
        this.installExceptionHandler(exceptionContext);
    }

    public Scalar getExceptionMessage() {
        this.request &= 0xFFFFFFEF;
        Scalar scalar = this.rv;
        this.rv = null;
        return scalar;
    }

    public Block getExceptionHandler() {
        this.request &= 0xFFFFFFEF;
        Block block = this.currentHandler.handler;
        Scalar scalar = this.getScriptVariables().getScalar(this.currentHandler.varname, this.getScriptInstance());
        if (scalar != null) {
            scalar.setValue(this.rv);
        } else {
            this.putScalar(this.currentHandler.varname, this.rv);
        }
        this.rv = null;
        return block;
    }

    public ExceptionContext popExceptionContext() {
        ExceptionContext exceptionContext = this.currentHandler;
        this.currentHandler = this.exhandlers.isEmpty() ? null : (ExceptionContext)this.exhandlers.pop();
        return exceptionContext;
    }

    public boolean isThrownValue() {
        return (this.request & 0x10) == 16;
    }

    public boolean isDebugInterrupt() {
        return (this.request & 0x20) == 32;
    }

    public boolean isYield() {
        return (this.request & 8) == 8;
    }

    public boolean isCallCC() {
        return (this.request & 0x48) == 72;
    }

    public boolean isPassControl() {
        return (this.request & 0x80) == 128;
    }

    public Scalar getReturnValue() {
        return this.rv;
    }

    public boolean isReturn() {
        return this.request != 0;
    }

    public int getFlowControlRequest() {
        return this.request;
    }

    public String getDebugString() {
        this.request &= 0xFFFFFFDF;
        return this.debugString;
    }

    public void showDebugMessage(String string) {
        this.request |= 0x20;
        this.debugString = string;
    }

    public void flagReturn(Scalar scalar, int n) {
        if (scalar == null) {
            scalar = SleepUtils.getEmptyScalar();
        }
        this.rv = scalar;
        this.request = n;
    }

    public void resetEnvironment() {
        this.errorMessage = null;
        this.request = 0;
        this.rv = null;
        this.getScriptInstance().clearStackTrace();
    }

    public void clearReturn() {
        this.request = 0 | this.request & 0xB0;
        if (!this.isThrownValue() && !this.isPassControl()) {
            this.rv = null;
        }
    }

    public void pushSource(String string) {
        this.sources.push(string);
    }

    public String getCurrentSource() {
        if (!this.sources.isEmpty()) {
            return this.sources.peek() + "";
        }
        return "unknown";
    }

    public void popSource() {
        this.sources.pop();
    }

    public int markFrame() {
        return this.findex;
    }

    public void cleanFrame(int n) {
        while (this.findex > n) {
            this.KillFrame();
        }
    }

    public Stack getCurrentFrame() {
        return (Stack)this.frames.get(this.findex);
    }

    public void FrameResult(Scalar scalar) {
        this.KillFrame();
        if (this.findex >= 0) {
            this.getCurrentFrame().push(scalar);
        }
    }

    public boolean hasFrame() {
        return this.findex >= 0;
    }

    public void KillFrame() {
        this.getCurrentFrame().clear();
        --this.findex;
    }

    public void CreateFrame(Stack stack) {
        if (stack == null) {
            stack = new Stack();
        }
        if (this.findex + 1 >= this.frames.size()) {
            this.frames.add(stack);
        } else {
            this.frames.set(this.findex + 1, stack);
        }
        ++this.findex;
    }

    public void CreateFrame() {
        if (this.findex + 1 >= this.frames.size()) {
            this.frames.add(new Stack());
        }
        ++this.findex;
    }

    public Scalar evaluateStatement(String string) throws YourCodeSucksException {
        return SleepUtils.runCode(SleepUtils.ParseCode(string), this);
    }

    public boolean evaluatePredicate(String string) throws YourCodeSucksException {
        string = "if (" + string + ") { return 1; } else { return $null; }";
        return SleepUtils.runCode(SleepUtils.ParseCode(string), this).intValue() == 1;
    }

    public Scalar evaluateExpression(String string) throws YourCodeSucksException {
        string = "return (" + string + ");";
        return SleepUtils.runCode(SleepUtils.ParseCode(string), this);
    }

    public Scalar evaluateParsedLiteral(String string) throws YourCodeSucksException {
        string = "return \"" + string + "\";";
        return SleepUtils.runCode(SleepUtils.ParseCode(string), this);
    }

    protected static class ExceptionContext
    implements Serializable {
        public Block owner;
        public String varname;
        public Block handler;

        protected ExceptionContext() {
        }
    }

    protected static class Context
    implements Serializable {
        public Block block;
        public Step last;
        public ExceptionContext handler;
        public boolean moreHandlers;

        protected Context() {
        }
    }
}

